/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.delta.api;

import io.cdap.delta.api.ChangeType;
import io.cdap.delta.api.Offset;
import java.util.Objects;

public abstract class ChangeEvent {
    private final Offset offset;
    private final boolean isSnapshot;
    private final ChangeType changeType;

    protected ChangeEvent(Offset offset, boolean isSnapshot, ChangeType changeType) {
        this.offset = offset;
        this.isSnapshot = isSnapshot;
        this.changeType = changeType;
    }

    public Offset getOffset() {
        return this.offset;
    }

    public boolean isSnapshot() {
        return this.isSnapshot;
    }

    public ChangeType getChangeType() {
        return this.changeType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ChangeEvent that = (ChangeEvent)o;
        return this.isSnapshot == that.isSnapshot && Objects.equals(this.offset, that.offset) && this.changeType == that.changeType;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.offset, this.isSnapshot, this.changeType});
    }

    public static class Builder<T extends Builder> {
        protected Offset offset;
        protected boolean isSnapshot;

        public T setOffset(Offset offset) {
            this.offset = offset;
            return (T)this;
        }

        public T setSnapshot(boolean isSnapshot) {
            this.isSnapshot = isSnapshot;
            return (T)this;
        }
    }
}

