/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.delta.api.assessment;

import io.cdap.delta.api.assessment.ColumnSuggestion;
import io.cdap.delta.api.assessment.ColumnSupport;
import java.util.Objects;
import javax.annotation.Nullable;

public class ColumnAssessment {
    private final String name;
    private final String type;
    private final String sourceName;
    private final ColumnSupport support;
    private final ColumnSuggestion suggestion;

    private ColumnAssessment(ColumnSupport support, String name, String type, @Nullable String sourceName, @Nullable ColumnSuggestion suggestion) {
        this.name = name;
        this.type = type;
        this.sourceName = sourceName;
        this.support = support;
        this.suggestion = suggestion;
    }

    @Nullable
    public String getSourceName() {
        return this.sourceName;
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public ColumnSupport getSupport() {
        return this.support;
    }

    @Nullable
    public ColumnSuggestion getSuggestion() {
        return this.suggestion;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ColumnAssessment that = (ColumnAssessment)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.type, that.type) && Objects.equals(this.sourceName, that.sourceName) && this.support == that.support && Objects.equals(this.suggestion, that.suggestion);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.type, this.sourceName, this.support, this.suggestion});
    }

    public static Builder builder(String name, String type) {
        return new Builder(name, type);
    }

    public static class Builder {
        private String name;
        private String type;
        private String sourceName;
        private ColumnSupport support;
        private ColumnSuggestion suggestion;

        private Builder(String name, String type) {
            this.name = name;
            this.type = type;
            this.support = ColumnSupport.YES;
        }

        public Builder setSupport(ColumnSupport support) {
            this.support = support;
            return this;
        }

        public Builder setSuggestion(ColumnSuggestion suggestion) {
            this.suggestion = suggestion;
            return this;
        }

        public Builder setSourceColumn(String sourceColumnName) {
            this.sourceName = sourceColumnName;
            return this;
        }

        public ColumnAssessment build() {
            return new ColumnAssessment(this.support, this.name, this.type, this.sourceName, this.suggestion);
        }
    }
}

