/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.delta.api;

import io.cdap.cdap.api.data.format.StructuredRecord;
import io.cdap.delta.api.ChangeEvent;
import io.cdap.delta.api.ChangeType;
import io.cdap.delta.api.DMLOperation;
import io.cdap.delta.api.Offset;
import java.util.Objects;
import javax.annotation.Nullable;

public class DMLEvent
extends ChangeEvent {
    private final DMLOperation operation;
    private final String database;
    private final String table;
    private final StructuredRecord row;
    private final StructuredRecord previousRow;
    private final String transactionId;
    private final long ingestTimestampMillis;

    private DMLEvent(Offset offset, DMLOperation operation, String database, String table, StructuredRecord row, @Nullable StructuredRecord previousRow, @Nullable String transactionId, long ingestTimestampMillis, boolean isSnapshot) {
        super(offset, isSnapshot, ChangeType.DML);
        this.operation = operation;
        this.database = database;
        this.table = table;
        this.row = row;
        this.previousRow = previousRow;
        this.transactionId = transactionId;
        this.ingestTimestampMillis = ingestTimestampMillis;
    }

    public DMLOperation getOperation() {
        return this.operation;
    }

    public String getDatabase() {
        return this.database;
    }

    public String getTable() {
        return this.table;
    }

    public StructuredRecord getRow() {
        return this.row;
    }

    @Nullable
    public StructuredRecord getPreviousRow() {
        return this.previousRow;
    }

    public String getTransactionId() {
        return this.transactionId;
    }

    public long getIngestTimestampMillis() {
        return this.ingestTimestampMillis;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DMLEvent dmlEvent = (DMLEvent)o;
        return this.ingestTimestampMillis == dmlEvent.ingestTimestampMillis && this.operation == dmlEvent.operation && Objects.equals(this.database, dmlEvent.database) && Objects.equals(this.table, dmlEvent.table) && Objects.equals(this.row, dmlEvent.row) && Objects.equals(this.previousRow, dmlEvent.previousRow) && Objects.equals(this.transactionId, dmlEvent.transactionId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.operation, this.database, this.table, this.row, this.previousRow, this.transactionId, this.ingestTimestampMillis});
    }

    public static Builder builder(DMLEvent event) {
        return new Builder(event);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends ChangeEvent.Builder<Builder> {
        private DMLOperation operation;
        private String database;
        private String table;
        private StructuredRecord row;
        private StructuredRecord previousRow;
        private String transactionId;
        private long ingestTimestampMillis;

        private Builder() {
        }

        private Builder(DMLEvent event) {
            this.offset = event.getOffset();
            this.operation = event.getOperation();
            this.database = event.getDatabase();
            this.table = event.getTable();
            this.row = event.getRow();
            this.previousRow = event.getPreviousRow();
            this.transactionId = event.getTransactionId();
            this.ingestTimestampMillis = event.getIngestTimestampMillis();
            this.isSnapshot = event.isSnapshot();
        }

        public Builder setOperation(DMLOperation operation) {
            this.operation = operation;
            return this;
        }

        public Builder setDatabase(String database) {
            this.database = database;
            return this;
        }

        public Builder setTable(String table) {
            this.table = table;
            return this;
        }

        public Builder setRow(StructuredRecord row) {
            this.row = row;
            return this;
        }

        public Builder setPreviousRow(StructuredRecord previousRow) {
            this.previousRow = previousRow;
            return this;
        }

        public Builder setTransactionId(String transactionId) {
            this.transactionId = transactionId;
            return this;
        }

        public Builder setIngestTimestamp(long ingestTimestampMillis) {
            this.ingestTimestampMillis = ingestTimestampMillis;
            return this;
        }

        public DMLEvent build() {
            return new DMLEvent(this.offset, this.operation, this.database, this.table, this.row, this.previousRow, this.transactionId, this.ingestTimestampMillis, this.isSnapshot);
        }
    }
}

