/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.delta.api;

import io.cdap.cdap.api.data.schema.Schema;
import io.cdap.delta.api.ChangeEvent;
import io.cdap.delta.api.ChangeType;
import io.cdap.delta.api.DDLOperation;
import io.cdap.delta.api.Offset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

public class DDLEvent
extends ChangeEvent {
    private final DDLOperation operation;
    private final Schema schema;
    private final String database;
    private final String prevTable;
    private final String table;
    private final List<String> primaryKey;

    private DDLEvent(Offset offset, DDLOperation operation, @Nullable Schema schema, String database, @Nullable String prevTable, @Nullable String table, List<String> primaryKey, boolean isSnapshot) {
        super(offset, isSnapshot, ChangeType.DDL);
        this.operation = operation;
        this.schema = schema;
        this.database = database;
        this.prevTable = prevTable;
        this.table = table;
        this.primaryKey = Collections.unmodifiableList(new ArrayList<String>(primaryKey));
    }

    public DDLOperation getOperation() {
        return this.operation;
    }

    @Nullable
    public Schema getSchema() {
        return this.schema;
    }

    public String getDatabase() {
        return this.database;
    }

    public String getPrevTable() {
        return this.prevTable;
    }

    @Nullable
    public String getTable() {
        return this.table;
    }

    public List<String> getPrimaryKey() {
        return this.primaryKey;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DDLEvent ddlEvent = (DDLEvent)o;
        return this.operation == ddlEvent.operation && Objects.equals(this.schema, ddlEvent.schema) && Objects.equals(this.database, ddlEvent.database) && Objects.equals(this.prevTable, ddlEvent.prevTable) && Objects.equals(this.table, ddlEvent.table) && Objects.equals(this.primaryKey, ddlEvent.primaryKey);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.operation, this.schema, this.database, this.prevTable, this.table, this.primaryKey});
    }

    public static Builder builder(DDLEvent event) {
        return new Builder(event);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends ChangeEvent.Builder<Builder> {
        private DDLOperation operation;
        private Schema schema;
        private String database;
        private String prevTable;
        private String table;
        private List<String> primaryKey = new ArrayList<String>();

        private Builder() {
        }

        private Builder(DDLEvent event) {
            this.offset = event.getOffset();
            this.isSnapshot = event.isSnapshot();
            this.operation = event.getOperation();
            this.schema = event.getSchema();
            this.database = event.getDatabase();
            this.prevTable = event.getPrevTable();
            this.table = event.getTable();
            this.primaryKey = event.getPrimaryKey();
        }

        public Builder setOperation(DDLOperation operation) {
            this.operation = operation;
            return this;
        }

        public Builder setSchema(Schema schema) {
            this.schema = schema;
            return this;
        }

        public Builder setDatabase(String database) {
            this.database = database;
            return this;
        }

        public Builder setPrevTable(String prevTable) {
            this.prevTable = prevTable;
            return this;
        }

        public Builder setTable(String table) {
            this.table = table;
            return this;
        }

        public Builder setPrimaryKey(List<String> primaryKey) {
            this.primaryKey = new ArrayList<String>(primaryKey);
            return this;
        }

        public DDLEvent build() {
            return new DDLEvent(this.offset, this.operation, this.schema, this.database, this.prevTable, this.table, this.primaryKey, this.isSnapshot);
        }
    }
}

