/*
 * Decompiled with CFR 0.152.
 */
package io.cdap;

import com.google.common.base.Strings;
import java.io.File;
import java.io.IOException;
import java.time.Instant;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.codehaus.plexus.util.FileUtils;
import org.json.JSONArray;
import org.json.JSONObject;

@Mojo(name="create-plugin-spec-json")
public class SpecJsonCreator
extends AbstractMojo {
    public static final String ONE_STEP_DEPLOY_PLUGIN = "one_step_deploy_plugin";
    public static final String CREATE_PIPELINE_DRAFT = "create_pipeline_draft";
    private static final String SPEC_VERSION = "specVersion";
    private static final String LABEL = "label";
    private static final String DESCRIPTION = "description";
    private static final String AUTHOR = "author";
    private static final String ORG = "org";
    private static final String CREATED = "created";
    private static final String CATEGORIES = "categories";
    private static final String CDAP_VERSION = "cdapVersion";
    private static final String ACTIONS = "actions";
    private static final String SPEC_JSON = "spec.json";
    public static final String LIVERAMP = "Liveramp";
    @Parameter(property="isPipeline", defaultValue="false")
    private boolean isPipeline;
    @Parameter(property="cdapArtifacts", required=true)
    private String[] cdapArtifacts;
    @Parameter(property="version", defaultValue="${project.version}")
    private String version;
    @Parameter(property="label", defaultValue="${project.name}")
    private String label;
    @Parameter(property="description", defaultValue="${project.description}")
    private String description;
    @Parameter(property="author")
    private String author;
    @Parameter(property="org")
    private String org;
    @Parameter(property="categories")
    private String[] categories;
    @Parameter(property="additionalActionArguments")
    private String[][] additionalActionArguments;
    @Parameter(property="actionType", defaultValue="one_step_deploy_plugin")
    private String actionType;
    @Parameter(property="scope", defaultValue="user")
    private String scope;
    @Parameter(property="buildDirectory", defaultValue="${project.build.directory}")
    private String buildDirectory;
    @Parameter(property="artifactId", defaultValue="${project.artifactId}")
    private String artifactId;
    private long created;
    private String cdapVersion;
    private String configFilename;

    public SpecJsonCreator() {
    }

    SpecJsonCreator(String actionType, String scope, String[] cdapArtifacts, String artifactId, String version, String label, String description, String author, String org, String[] categories, String buildDirectory, boolean isPipeline, String[][] additionalActionArguments) {
        this.actionType = actionType;
        this.scope = scope;
        this.cdapArtifacts = cdapArtifacts;
        this.artifactId = artifactId;
        this.version = version;
        this.label = label;
        this.description = description;
        this.author = author;
        this.org = org;
        this.categories = categories;
        this.isPipeline = isPipeline;
        this.additionalActionArguments = additionalActionArguments;
        this.buildDirectory = buildDirectory;
    }

    public void execute() throws MojoExecutionException {
        this.initialize();
        this.printHeader();
        JSONObject output = new JSONObject();
        output.put(SPEC_VERSION, (Object)this.version);
        output.put(LABEL, (Object)this.label);
        output.put(DESCRIPTION, (Object)this.description);
        if (!Strings.isNullOrEmpty((String)this.author)) {
            output.put(AUTHOR, (Object)this.author);
        }
        if (!Strings.isNullOrEmpty((String)this.org)) {
            output.put(ORG, (Object)this.org);
        }
        output.put(CREATED, this.created);
        output.put(CATEGORIES, (Object)this.categories);
        output.put(CDAP_VERSION, (Object)this.cdapVersion);
        JSONArray actions = new JSONArray();
        JSONArray additionalArguments = new JSONArray();
        if (this.additionalActionArguments != null) {
            for (String[] pair : this.additionalActionArguments) {
                String key = pair[0];
                String value = pair[1];
                JSONObject argument = this.createActionArgument(key, value);
                additionalArguments.put((Object)argument);
            }
        }
        JSONObject actionJson = this.createAction(this.actionType, this.label, this.version, this.scope, this.configFilename, this.isPipeline, additionalArguments);
        actions.put((Object)actionJson);
        output.put(ACTIONS, (Object)actions);
        try {
            File outputFile = new File(this.buildDirectory, SPEC_JSON);
            if (outputFile.exists()) {
                outputFile.delete();
            }
            outputFile.createNewFile();
            FileUtils.fileWrite((String)outputFile.getAbsolutePath(), (String)output.toString(2));
            this.getLog().info((CharSequence)"Successfully created: spec.json");
        }
        catch (IOException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
        this.printFooter();
    }

    private JSONObject createAction(String type, String label, String version, String scope, String config, boolean isPipeline, JSONArray additionalArguments) {
        JSONObject actionJson = new JSONObject();
        actionJson.put("type", (Object)type);
        actionJson.put(LABEL, (Object)label);
        JSONArray actionArguments = new JSONArray();
        JSONObject nameArg = this.createActionArgument("name", this.artifactId);
        JSONObject versionArg = this.createActionArgument("version", version);
        JSONObject scopeArg = this.createActionArgument("scope", scope);
        JSONObject configArg = this.createActionArgument("config", config);
        actionArguments.put((Object)nameArg);
        actionArguments.put((Object)versionArg);
        actionArguments.put((Object)scopeArg);
        actionArguments.put((Object)configArg);
        for (Object addArg : additionalArguments) {
            actionArguments.put(addArg);
        }
        if (isPipeline) {
            actionArguments.put((Object)this.createPipelineArtifactArgument());
        }
        actionJson.put("arguments", (Object)actionArguments);
        return actionJson;
    }

    private JSONObject createActionArgument(String name, String value) {
        JSONObject actionArgument = new JSONObject();
        actionArgument.put("name", (Object)name);
        actionArgument.put("value", (Object)value);
        return actionArgument;
    }

    private JSONObject createPipelineArtifactArgument() {
        JSONObject actionArgument = new JSONObject();
        JSONObject valueObject = new JSONObject();
        valueObject.put("scope", (Object)"SYSTEM");
        valueObject.put("name", (Object)"cdap-data-pipeline");
        valueObject.put("version", (Object)"[6.1.1, 7.0.0-SNAPSHOT)");
        actionArgument.put("name", (Object)"artifact");
        actionArgument.put("value", (Object)valueObject);
        return actionArgument;
    }

    private String filterVersions(String cdapArtifact) {
        String empty = "";
        if (cdapArtifact == null || cdapArtifact.isEmpty()) {
            return empty;
        }
        int leftBracket = cdapArtifact.indexOf("[");
        if (leftBracket < 0) {
            leftBracket = cdapArtifact.indexOf("(");
        }
        if (leftBracket < 0) {
            return empty;
        }
        int rightBracket = cdapArtifact.indexOf("]");
        if (rightBracket < 0) {
            rightBracket = cdapArtifact.indexOf(")");
        }
        if (rightBracket < 0) {
            return empty;
        }
        return cdapArtifact.substring(leftBracket, rightBracket + 1);
    }

    private void initialize() {
        this.created = Instant.now().toEpochMilli();
        this.cdapVersion = this.filterVersions(this.cdapArtifacts[0]);
        this.configFilename = this.artifactId + "-" + this.version + ".json";
        if (this.isPipeline && ONE_STEP_DEPLOY_PLUGIN.equals(this.actionType)) {
            this.actionType = CREATE_PIPELINE_DRAFT;
        }
        File buildDirectoryDir = new File(this.buildDirectory);
        buildDirectoryDir.mkdirs();
    }

    private void printHeader() {
        this.getLog().info((CharSequence)this.repeat("-", 72));
        this.getLog().info((CharSequence)"CDAP Plugin JSON - Spec Json creator");
        this.getLog().info((CharSequence)this.repeat("-", 72));
        this.getLog().info((CharSequence)("specVersion          : " + this.version));
        this.getLog().info((CharSequence)("label                : " + this.label));
        this.getLog().info((CharSequence)("description          : " + this.description));
        if (!Strings.isNullOrEmpty((String)this.author)) {
            this.getLog().info((CharSequence)("author               : " + this.author));
        }
        if (!Strings.isNullOrEmpty((String)this.org)) {
            this.getLog().info((CharSequence)("org                  : " + this.org));
        }
        this.getLog().info((CharSequence)("created              : " + this.created));
        this.getLog().info((CharSequence)("cdapVersion          : " + this.cdapVersion));
        this.getLog().info((CharSequence)("action type          : " + this.actionType));
        this.getLog().info((CharSequence)("action arg name      : " + this.artifactId));
        this.getLog().info((CharSequence)("action arg version   : " + this.version));
        this.getLog().info((CharSequence)("action arg scope     : " + this.scope));
        this.getLog().info((CharSequence)("action arg config    : " + this.configFilename));
        if (this.categories != null) {
            this.getLog().info((CharSequence)CATEGORIES);
            for (String string : this.categories) {
                this.getLog().info((CharSequence)(" " + string));
            }
        }
        if (this.additionalActionArguments != null) {
            this.getLog().info((CharSequence)"additionalActionArguments");
            for (String string : this.additionalActionArguments) {
                this.getLog().info((CharSequence)(" " + string[0] + " : " + string[1]));
            }
        }
        this.getLog().info((CharSequence)this.repeat("-", 72));
    }

    private void printFooter() {
        this.getLog().info((CharSequence)this.repeat("-", 72));
    }

    private String repeat(String text, int numRepetitions) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < numRepetitions; ++i) {
            builder.append(text);
        }
        return builder.toString();
    }
}

