/*
 * Decompiled with CFR 0.152.
 */
package io.cdap;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.codehaus.plexus.util.FileUtils;
import org.json.JSONObject;
import org.json.JSONTokener;

@Mojo(name="create-pipeline-json")
public class PipelineJson
extends AbstractMojo {
    @Parameter(required=true)
    private String pipelineJsonFile;
    @Parameter(property="buildDirectory", defaultValue="${project.build.directory}")
    private String buildDirectory;
    @Parameter(property="artifactId", defaultValue="${project.artifactId}")
    private String artifactId;
    @Parameter(property="version", defaultValue="${project.version}")
    private String version;

    public void execute() throws MojoExecutionException {
        File outputDir = new File(this.buildDirectory);
        outputDir.mkdirs();
        try {
            this.getLog().info((CharSequence)("PATH : " + Paths.get(this.pipelineJsonFile, new String[0])));
            JSONTokener jsonTokener = new JSONTokener(Files.newInputStream(Paths.get(this.pipelineJsonFile, new String[0]), new OpenOption[0]));
            JSONObject output = new JSONObject(jsonTokener);
            if (!output.has("config")) {
                throw new MojoExecutionException("Incorrect PipelineJsonFile: expecting 'config' property");
            }
            File outputFile = new File(outputDir, this.artifactId + "-" + this.version + ".json");
            if (outputFile.exists()) {
                outputFile.delete();
            }
            outputFile.createNewFile();
            FileUtils.fileWrite((String)outputFile.getAbsolutePath(), (String)output.get("config").toString());
            this.getLog().info((CharSequence)("Successfully created: " + this.pipelineJsonFile));
        }
        catch (IOException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
    }
}

