/*
 * Decompiled with CFR 0.152.
 */
package io.cdap;

import java.io.File;
import java.io.IOException;
import java.nio.file.Paths;
import org.apache.commons.io.FileUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="package-artifacts-for-hub")
public class ArtifactPackager
extends AbstractMojo {
    @Parameter(defaultValue="${project.build.directory}/packages/", required=true)
    private String relativeOutputDir;
    @Parameter(property="buildDirectory", defaultValue="${project.build.directory}")
    private String buildDirectory;
    @Parameter(property="baseDir", defaultValue="${project.baseDir}")
    private String baseDirectory;
    @Parameter(property="artifactId", defaultValue="${project.artifactId}")
    private String artifactId;
    @Parameter(property="version", defaultValue="${project.version}")
    private String version;
    @Parameter(property="isPipeline", defaultValue="false")
    private boolean isPipeline;
    @Parameter(defaultValue="icons")
    private String iconsDirectory;

    public void execute() throws MojoExecutionException, MojoFailureException {
        File[] iconFiles;
        String currentPath = null;
        try {
            currentPath = new File(".").getCanonicalPath();
            this.getLog().info((CharSequence)("Working Directory = " + System.getProperty("user.dir")));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.getLog().info((CharSequence)("Current dir:" + currentPath));
        File outputDirectory = Paths.get(this.relativeOutputDir, this.artifactId, this.version).toFile();
        File iconDirectory = new File(this.baseDirectory, this.iconsDirectory);
        this.getLog().info((CharSequence)("Creating artifact output dir at: " + outputDirectory.getAbsolutePath()));
        outputDirectory.mkdirs();
        this.moveFile(outputDirectory, this.artifactId + "-" + this.version + ".jar");
        this.moveFile(outputDirectory, this.artifactId + "-" + this.version + ".json");
        this.moveFile(outputDirectory, "spec.json");
        if (iconDirectory.exists() && (iconFiles = iconDirectory.listFiles()) != null) {
            for (File icon : iconFiles) {
                this.moveFile(outputDirectory, icon, icon.getName());
            }
        }
    }

    private void moveFile(File outputDirectory, String fileName) {
        File artifactSource = new File(this.buildDirectory, fileName);
        if (artifactSource.exists()) {
            this.moveFile(outputDirectory, artifactSource, fileName);
        } else {
            this.getLog().warn((CharSequence)(artifactSource.getName() + " does not exist!"));
        }
    }

    private void moveFile(File outputDirectory, File fileSource, String fileName) {
        File fileDestination = new File(outputDirectory, fileName);
        try {
            if (!this.isPipeline || !fileName.endsWith(".jar")) {
                this.getLog().info((CharSequence)("Copying " + fileName + " to " + fileDestination.getCanonicalPath()));
                FileUtils.copyFile((File)fileSource, (File)fileDestination);
            }
        }
        catch (IOException e) {
            this.getLog().error((Throwable)e);
        }
    }
}

