/*
 * Decompiled with CFR 0.152.
 */
package io.carml.util;

import io.carml.model.FileSource;
import io.carml.model.NameableStream;
import io.carml.model.TermType;
import io.carml.model.TriplesMap;
import io.carml.model.XmlSource;
import io.carml.model.impl.CarmlFileSource;
import io.carml.model.impl.CarmlStream;
import io.carml.model.impl.CarmlTriplesMap;
import io.carml.model.impl.CarmlXmlSource;
import io.carml.rdfmapper.impl.MappingCache;
import io.carml.rdfmapper.util.RdfObjectLoader;
import io.carml.util.Models;
import io.carml.util.RmlConstantShorthandExpander;
import io.carml.util.RmlMappingLoaderException;
import io.carml.util.RmlNamespaces;
import io.carml.vocab.Rdf;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import java.util.function.UnaryOperator;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.util.ModelCollector;
import org.eclipse.rdf4j.rio.RDFFormat;

public class RmlMappingLoader {
    private final RmlConstantShorthandExpander shorthandExpander;

    public static RmlMappingLoader build() {
        return new RmlMappingLoader(new RmlConstantShorthandExpander());
    }

    private RmlMappingLoader(RmlConstantShorthandExpander shorthandExpander) {
        this.shorthandExpander = shorthandExpander;
    }

    public Set<TriplesMap> load(RDFFormat rdfFormat, String ... classPathResources) {
        InputStream[] inputs = (InputStream[])Arrays.stream(classPathResources).map(RmlMappingLoader.class.getClassLoader()::getResourceAsStream).toArray(InputStream[]::new);
        return this.load(rdfFormat, inputs);
    }

    public Set<TriplesMap> load(RDFFormat rdfFormat, Path ... pathsToFile) {
        InputStream[] inputs = (InputStream[])Arrays.stream(pathsToFile).map(path -> {
            InputStream input;
            try {
                input = Files.newInputStream(path, new OpenOption[0]);
            }
            catch (IOException ioException) {
                throw new RmlMappingLoaderException(String.format("Exception while load mapping from path %s", path), ioException);
            }
            return input;
        }).toArray(InputStream[]::new);
        return this.load(rdfFormat, inputs);
    }

    public Set<TriplesMap> load(RDFFormat rdfFormat, InputStream ... inputs) {
        Model[] models = (Model[])Arrays.stream(inputs).map(inputStream -> Models.parse((InputStream)inputStream, (RDFFormat)rdfFormat)).toArray(Model[]::new);
        return this.load(models);
    }

    public Set<TriplesMap> load(Model ... models) {
        Model model = (Model)Arrays.stream(models).flatMap(Collection::stream).collect(ModelCollector.toModel());
        return Set.copyOf(RdfObjectLoader.load(RmlMappingLoader::selectTriplesMaps, CarmlTriplesMap.class, (Model)model, (UnaryOperator)this.shorthandExpander, this::addTermTypes, mapper -> {
            mapper.addDecidableType(Rdf.Carml.Stream, NameableStream.class);
            mapper.addDecidableType(Rdf.Carml.XmlDocument, XmlSource.class);
            mapper.addDecidableType(Rdf.Carml.FileSource, FileSource.class);
            mapper.bindInterfaceImplementation(NameableStream.class, CarmlStream.class);
            mapper.bindInterfaceImplementation(XmlSource.class, CarmlXmlSource.class);
            mapper.bindInterfaceImplementation(FileSource.class, CarmlFileSource.class);
        }, RmlNamespaces.RML_NAMESPACES));
    }

    private static Set<Resource> selectTriplesMaps(Model model) {
        return Set.copyOf(model.filter(null, Rdf.Rml.logicalSource, null, new Resource[0]).subjects());
    }

    private void addTermTypes(final MappingCache cache) {
        class AddTermTypes {
            AddTermTypes() {
            }

            void add(IRI iri, TermType termType) {
                cache.addCachedMapping((Resource)iri, Set.of(TermType.class), (Object)termType);
            }

            void run() {
                this.add(Rdf.Rr.BlankNode, TermType.BLANK_NODE);
                this.add(Rdf.Rr.IRI, TermType.IRI);
                this.add(Rdf.Rr.Literal, TermType.LITERAL);
            }
        }
        new AddTermTypes().run();
    }
}

