/*
 * Decompiled with CFR 0.152.
 */
package io.carml.util;

import com.google.common.collect.ImmutableMap;
import io.carml.vocab.Rdf;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.UnaryOperator;
import org.eclipse.rdf4j.model.BNode;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.impl.LinkedHashModel;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;

public class RmlConstantShorthandExpander
implements UnaryOperator<Model> {
    private static final List<IRI> shortcutPredicates = Arrays.asList(Rdf.Rr.subject, Rdf.Rr.predicate, Rdf.Rr.object, Rdf.Rr.graph, Rdf.Rr.datatype, Rdf.Rr.language);
    private static final Map<IRI, IRI> expandedPredicates;
    private static final ValueFactory VALUE_FACTORY;

    private IRI getExpandedPredicate(IRI shortcutPredicate) {
        if (!expandedPredicates.containsKey(shortcutPredicate)) {
            throw new IllegalArgumentException(String.format("predicate [%s] is not a valid shortcut predicate", shortcutPredicate));
        }
        return expandedPredicates.get(shortcutPredicate);
    }

    @Override
    public Model apply(Model input) {
        LinkedHashModel model = new LinkedHashModel();
        input.forEach(arg_0 -> this.lambda$apply$0((Model)model, arg_0));
        return model;
    }

    private void expandStatements(Model model, Statement statement) {
        IRI shortcutPredicate = statement.getPredicate();
        if (!shortcutPredicates.contains(shortcutPredicate)) {
            model.add((Object)statement);
            return;
        }
        Resource context = statement.getContext();
        BNode blankNode = VALUE_FACTORY.createBNode();
        model.add(statement.getSubject(), this.getExpandedPredicate(shortcutPredicate), (Value)blankNode, new Resource[]{context});
        model.add((Resource)blankNode, Rdf.Rr.constant, statement.getObject(), new Resource[]{context});
    }

    private /* synthetic */ void lambda$apply$0(Model model, Statement statement) {
        this.expandStatements(model, statement);
    }

    static {
        VALUE_FACTORY = SimpleValueFactory.getInstance();
        class CreateExpandedPredicates {
            final Map<IRI, IRI> expandedPredicates = new LinkedHashMap<IRI, IRI>();

            CreateExpandedPredicates() {
            }

            void add(IRI shortcutPredicate, IRI expandedPredicate) {
                this.expandedPredicates.put(shortcutPredicate, expandedPredicate);
            }

            Map<IRI, IRI> run() {
                this.add(Rdf.Rr.subject, Rdf.Rr.subjectMap);
                this.add(Rdf.Rr.predicate, Rdf.Rr.predicateMap);
                this.add(Rdf.Rr.object, Rdf.Rr.objectMap);
                this.add(Rdf.Rr.graph, Rdf.Rr.graphMap);
                this.add(Rdf.Rr.datatype, Rdf.Rml.datatypeMap);
                this.add(Rdf.Rr.language, Rdf.Rml.languageMap);
                return ImmutableMap.copyOf(this.expandedPredicates);
            }
        }
        expandedPredicates = new CreateExpandedPredicates().run();
    }
}

