/*
 * Decompiled with CFR 0.152.
 */
package io.carml.util;

import io.carml.model.ExpressionMap;
import io.carml.model.ObjectMap;
import io.carml.model.RefObjectMap;
import io.carml.model.SubjectMap;
import io.carml.model.TermMap;
import io.carml.model.TriplesMap;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class Mapping {
    private Mapping() {
    }

    public static Set<TriplesMap> filterMappable(Set<TriplesMap> mapping) {
        Set functionValueTriplesMaps = Mapping.getTermMaps(mapping).map(ExpressionMap::getFunctionValue).filter(Objects::nonNull).collect(Collectors.toUnmodifiableSet());
        Set<TriplesMap> refObjectTriplesMaps = Mapping.getAllTriplesMapsUsedInRefObjectMap(mapping);
        return mapping.stream().filter(m -> !functionValueTriplesMaps.contains(m) || refObjectTriplesMaps.contains(m)).collect(Collectors.toUnmodifiableSet());
    }

    private static Stream<TermMap> getTermMaps(Set<TriplesMap> mapping) {
        return mapping.stream().flatMap(m -> Stream.concat(m.getPredicateObjectMaps().stream().flatMap(p -> Stream.concat(p.getGraphMaps().stream(), Stream.concat(p.getPredicateMaps().stream(), p.getObjectMaps().stream().filter(ObjectMap.class::isInstance).map(ObjectMap.class::cast)))), Stream.concat(m.getSubjectMaps().stream(), m.getSubjectMaps().stream().map(SubjectMap::getGraphMaps).flatMap(Collection::stream)))).filter(Objects::nonNull);
    }

    private static Set<TriplesMap> getAllTriplesMapsUsedInRefObjectMap(Set<TriplesMap> mapping) {
        return mapping.stream().flatMap(m -> m.getPredicateObjectMaps().stream()).flatMap(p -> p.getObjectMaps().stream()).filter(RefObjectMap.class::isInstance).map(RefObjectMap.class::cast).map(RefObjectMap::getParentTriplesMap).collect(Collectors.toUnmodifiableSet());
    }
}

