/*
 * Decompiled with CFR 0.152.
 */
package io.carml.util;

import io.carml.model.Resource;
import io.carml.util.ModelSerializer;
import io.carml.util.RmlNamespaces;
import java.util.Collection;
import java.util.stream.Collectors;
import lombok.Generated;
import org.eclipse.rdf4j.model.Model;

public class LogUtil {
    public static String log(Resource resource) {
        return LogUtil.log(resource, resource);
    }

    public static String log(Collection<? extends Resource> resources) {
        return resources.stream().map(LogUtil::log).collect(Collectors.joining(String.format(",%n", new Object[0])));
    }

    public static String log(Resource ancestor, Resource resource) {
        return ModelSerializer.formatResourceForLog((Model)ancestor.asRdf(), (org.eclipse.rdf4j.model.Resource)resource.getAsResource(), RmlNamespaces.RML_NAMESPACES, (boolean)false);
    }

    public static String exception(Collection<? extends Resource> resources) {
        return resources.stream().map(LogUtil::exception).collect(Collectors.joining(String.format(",%n", new Object[0])));
    }

    public static String exception(Resource resource) {
        return LogUtil.exception(resource, resource);
    }

    public static String exception(Resource ancestor, Resource resource) {
        return ModelSerializer.formatResourceForLog((Model)ancestor.asRdf(), (org.eclipse.rdf4j.model.Resource)resource.getAsResource(), RmlNamespaces.RML_NAMESPACES, (boolean)true);
    }

    @Generated
    private LogUtil() {
    }
}

