/*
 * Decompiled with CFR 0.152.
 */
package io.carml.model.impl;

import io.carml.rdfmapper.Mapper;
import io.carml.rdfmapper.TypeDecider;
import io.carml.vocab.Rdf;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.vocabulary.RDF;

public class LogicalSourceSourceTypeDecider
implements TypeDecider {
    private final Mapper mapper;
    Map<IRI, IRI> inferenceMap = Map.of(Rdf.Carml.streamName, Rdf.Carml.Stream, Rdf.Carml.declaresNamespace, Rdf.Carml.XmlDocument, Rdf.Carml.url, Rdf.Carml.FileSource);

    public LogicalSourceSourceTypeDecider(Mapper mapper) {
        this.mapper = mapper;
    }

    public Set<Type> decide(Model model, Resource resource) {
        Set rdfTypes = model.filter(resource, RDF.TYPE, null, new Resource[0]).objects().stream().map(IRI.class::cast).collect(Collectors.toSet());
        Set<IRI> usedPredicates = model.filter(resource, null, null, new Resource[0]).predicates().stream().filter(p -> !p.equals((Object)RDF.TYPE)).collect(Collectors.toSet());
        usedPredicates.forEach(p -> {
            if (this.inferenceMap.containsKey(p)) {
                rdfTypes.add(this.inferenceMap.get(p));
            }
        });
        return rdfTypes.stream().map(arg_0 -> ((Mapper)this.mapper).getDecidableType(arg_0)).collect(Collectors.toSet());
    }
}

