/*
 * Decompiled with CFR 0.152.
 */
package io.carml.model.impl;

import io.carml.model.impl.LogicalSourceSourceTypeDecider;
import io.carml.rdfmapper.Mapper;
import io.carml.rdfmapper.PropertyHandler;
import io.carml.rdfmapper.TypeDecider;
import io.carml.rdfmapper.impl.CarmlMapperException;
import io.carml.rdfmapper.impl.ComplexValueTransformer;
import io.carml.rdfmapper.impl.MappingCache;
import io.carml.rdfmapper.qualifiers.PropertyPredicate;
import io.carml.rdfmapper.qualifiers.PropertySetter;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import javax.inject.Inject;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;

public class LogicalSourceSourcePropertyHandler
implements PropertyHandler {
    private IRI predicate;
    private BiConsumer<Object, Object> setter;
    private Mapper mapper;
    private MappingCache mappingCache;

    private Optional<Object> determineValue(Model model, Resource resource) {
        Set objects = model.filter(resource, this.predicate, null, new Resource[0]).objects();
        if (objects.size() > 1) {
            throw new CarmlMapperException(String.format("more than 1 object for the predicate [%s] for a logical source", this.predicate));
        }
        if (objects.isEmpty()) {
            return Optional.empty();
        }
        Value object = (Value)objects.iterator().next();
        if (object instanceof Literal) {
            return Optional.of(object.stringValue());
        }
        ComplexValueTransformer transformer = new ComplexValueTransformer((TypeDecider)new LogicalSourceSourceTypeDecider(this.mapper), this.mappingCache, this.mapper, o -> o);
        Object value = transformer.transform(model, object);
        return Optional.of(value);
    }

    public void handle(Model model, Resource resource, Object instance) {
        this.determineValue(model, resource).ifPresent(value -> this.setter.accept(instance, value));
    }

    public boolean hasEffect(Model model, Resource resource) {
        return !model.filter(resource, this.predicate, null, new Resource[0]).isEmpty();
    }

    @Inject
    @PropertyPredicate
    public void setPredicate(IRI predicate) {
        this.predicate = predicate;
    }

    @Inject
    @PropertySetter
    public void setSetter(BiConsumer<Object, Object> setter) {
        this.setter = setter;
    }

    @Inject
    public void setMapper(Mapper mapper) {
        this.mapper = mapper;
    }

    @Inject
    public void setMappingCache(MappingCache mappingCache) {
        this.mappingCache = mappingCache;
    }
}

