/*
 * Decompiled with CFR 0.152.
 */
package io.carml.model.impl;

import io.carml.model.Namespace;
import io.carml.model.Resource;
import io.carml.model.XmlSource;
import io.carml.model.impl.CarmlNamespace;
import io.carml.model.impl.CarmlResource;
import io.carml.rdfmapper.annotations.RdfProperty;
import io.carml.rdfmapper.annotations.RdfType;
import io.carml.vocab.Rdf;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import lombok.Generated;
import org.apache.commons.lang3.builder.MultilineRecursiveToStringStyle;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.eclipse.rdf4j.model.util.ModelBuilder;
import org.eclipse.rdf4j.model.vocabulary.RDF;

public class CarmlXmlSource
extends CarmlResource
implements XmlSource {
    private Set<Namespace> declaredNamespaces;

    @Override
    @RdfProperty(value="http://carml.taxonic.com/carml/declaresNamespace")
    @RdfType(value=CarmlNamespace.class)
    public Set<Namespace> getDeclaredNamespaces() {
        return this.declaredNamespaces;
    }

    public String toString() {
        return new ReflectionToStringBuilder((Object)this, (ToStringStyle)new MultilineRecursiveToStringStyle()).toString();
    }

    public int hashCode() {
        return Objects.hash(this.declaredNamespaces);
    }

    public boolean equals(Object obj) {
        if (obj instanceof XmlSource) {
            XmlSource other = (XmlSource)obj;
            return Objects.equals(this.declaredNamespaces, other.getDeclaredNamespaces());
        }
        return false;
    }

    @Override
    public Set<Resource> getReferencedResources() {
        return Set.copyOf(this.declaredNamespaces);
    }

    @Override
    public void addTriples(ModelBuilder modelBuilder) {
        modelBuilder.subject(this.getAsResource()).add(RDF.TYPE, (Object)Rdf.Carml.XmlDocument);
        this.declaredNamespaces.forEach(ns -> modelBuilder.add("http://carml.taxonic.com/carml/declaresNamespace", (Object)ns.getAsResource()));
    }

    @Generated
    protected CarmlXmlSource(CarmlXmlSourceBuilder<?, ?> b) {
        super(b);
        Set<Object> declaredNamespaces;
        switch (b.declaredNamespaces == null ? 0 : b.declaredNamespaces.size()) {
            case 0: {
                declaredNamespaces = Collections.emptySet();
                break;
            }
            case 1: {
                declaredNamespaces = Collections.singleton(b.declaredNamespaces.get(0));
                break;
            }
            default: {
                declaredNamespaces = new LinkedHashSet(b.declaredNamespaces.size() < 0x40000000 ? 1 + b.declaredNamespaces.size() + (b.declaredNamespaces.size() - 3) / 3 : Integer.MAX_VALUE);
                declaredNamespaces.addAll(b.declaredNamespaces);
                declaredNamespaces = Collections.unmodifiableSet(declaredNamespaces);
            }
        }
        this.declaredNamespaces = declaredNamespaces;
    }

    @Generated
    public static CarmlXmlSourceBuilder<?, ?> builder() {
        return new CarmlXmlSourceBuilderImpl();
    }

    @Generated
    public CarmlXmlSource() {
    }

    @Generated
    public void setDeclaredNamespaces(Set<Namespace> declaredNamespaces) {
        this.declaredNamespaces = declaredNamespaces;
    }

    @Generated
    private static final class CarmlXmlSourceBuilderImpl
    extends CarmlXmlSourceBuilder<CarmlXmlSource, CarmlXmlSourceBuilderImpl> {
        @Generated
        private CarmlXmlSourceBuilderImpl() {
        }

        @Override
        @Generated
        protected CarmlXmlSourceBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public CarmlXmlSource build() {
            return new CarmlXmlSource(this);
        }
    }

    @Generated
    public static abstract class CarmlXmlSourceBuilder<C extends CarmlXmlSource, B extends CarmlXmlSourceBuilder<C, B>>
    extends CarmlResource.CarmlResourceBuilder<C, B> {
        @Generated
        private ArrayList<Namespace> declaredNamespaces;

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Generated
        public B declaredNamespace(Namespace declaredNamespace) {
            if (this.declaredNamespaces == null) {
                this.declaredNamespaces = new ArrayList();
            }
            this.declaredNamespaces.add(declaredNamespace);
            return (B)this.self();
        }

        @Generated
        public B declaredNamespaces(Collection<? extends Namespace> declaredNamespaces) {
            if (declaredNamespaces == null) {
                throw new NullPointerException("declaredNamespaces cannot be null");
            }
            if (this.declaredNamespaces == null) {
                this.declaredNamespaces = new ArrayList();
            }
            this.declaredNamespaces.addAll(declaredNamespaces);
            return (B)this.self();
        }

        @Generated
        public B clearDeclaredNamespaces() {
            if (this.declaredNamespaces != null) {
                this.declaredNamespaces.clear();
            }
            return (B)this.self();
        }

        @Override
        @Generated
        public String toString() {
            return "CarmlXmlSource.CarmlXmlSourceBuilder(super=" + super.toString() + ", declaredNamespaces=" + this.declaredNamespaces + ")";
        }
    }
}

