/*
 * Decompiled with CFR 0.152.
 */
package io.carml.model.impl;

import com.google.common.collect.ImmutableSet;
import io.carml.model.LogicalSource;
import io.carml.model.PredicateObjectMap;
import io.carml.model.Resource;
import io.carml.model.SubjectMap;
import io.carml.model.TriplesMap;
import io.carml.model.impl.CarmlLogicalSource;
import io.carml.model.impl.CarmlPredicateObjectMap;
import io.carml.model.impl.CarmlResource;
import io.carml.model.impl.CarmlSubjectMap;
import io.carml.rdfmapper.annotations.RdfProperty;
import io.carml.rdfmapper.annotations.RdfType;
import io.carml.vocab.Rdf;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import lombok.Generated;
import org.apache.commons.lang3.builder.MultilineRecursiveToStringStyle;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.eclipse.rdf4j.model.util.ModelBuilder;
import org.eclipse.rdf4j.model.vocabulary.RDF;

public class CarmlTriplesMap
extends CarmlResource
implements TriplesMap {
    private LogicalSource logicalSource;
    private Set<SubjectMap> subjectMaps;
    private Set<PredicateObjectMap> predicateObjectMaps;

    @Override
    @RdfProperty(value="http://semweb.mmlab.be/ns/rml#logicalSource")
    @RdfType(value=CarmlLogicalSource.class)
    public LogicalSource getLogicalSource() {
        return this.logicalSource;
    }

    @Override
    @RdfProperty(value="http://www.w3.org/ns/r2rml#subjectMap")
    @RdfType(value=CarmlSubjectMap.class)
    public Set<SubjectMap> getSubjectMaps() {
        return this.subjectMaps;
    }

    @Override
    @RdfProperty(value="http://www.w3.org/ns/r2rml#predicateObjectMap")
    @RdfType(value=CarmlPredicateObjectMap.class)
    public Set<PredicateObjectMap> getPredicateObjectMaps() {
        return this.predicateObjectMaps;
    }

    public String toString() {
        MultilineRecursiveToStringStyle style = new MultilineRecursiveToStringStyle();
        StringBuffer buffer = new StringBuffer();
        buffer.append(String.format("%s %s:%n ", this.getClass().getSimpleName(), this.getResourceName()));
        return new ReflectionToStringBuilder((Object)this, (ToStringStyle)style, buffer).toString();
    }

    @Override
    public Set<Resource> getReferencedResources() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        if (this.logicalSource != null) {
            builder.add((Object)this.logicalSource);
        }
        return builder.addAll(this.subjectMaps).addAll(this.predicateObjectMaps).build();
    }

    @Override
    public void addTriples(ModelBuilder modelBuilder) {
        modelBuilder.subject(this.getAsResource()).add(RDF.TYPE, (Object)Rdf.Rr.TriplesMap);
        if (this.logicalSource != null) {
            modelBuilder.add("http://semweb.mmlab.be/ns/rml#logicalSource", (Object)this.logicalSource.getAsResource());
        }
        this.subjectMaps.forEach(sm -> modelBuilder.add("http://www.w3.org/ns/r2rml#subjectMap", (Object)sm.getAsResource()));
        this.predicateObjectMaps.forEach(pom -> modelBuilder.add("http://www.w3.org/ns/r2rml#predicateObjectMap", (Object)pom.getAsResource()));
    }

    @Generated
    protected CarmlTriplesMap(CarmlTriplesMapBuilder<?, ?> b) {
        super(b);
        Set<Object> predicateObjectMaps;
        Set<Object> subjectMaps;
        this.logicalSource = b.logicalSource;
        switch (b.subjectMaps == null ? 0 : b.subjectMaps.size()) {
            case 0: {
                subjectMaps = Collections.emptySet();
                break;
            }
            case 1: {
                subjectMaps = Collections.singleton(b.subjectMaps.get(0));
                break;
            }
            default: {
                subjectMaps = new LinkedHashSet(b.subjectMaps.size() < 0x40000000 ? 1 + b.subjectMaps.size() + (b.subjectMaps.size() - 3) / 3 : Integer.MAX_VALUE);
                subjectMaps.addAll(b.subjectMaps);
                subjectMaps = Collections.unmodifiableSet(subjectMaps);
            }
        }
        this.subjectMaps = subjectMaps;
        switch (b.predicateObjectMaps == null ? 0 : b.predicateObjectMaps.size()) {
            case 0: {
                predicateObjectMaps = Collections.emptySet();
                break;
            }
            case 1: {
                predicateObjectMaps = Collections.singleton(b.predicateObjectMaps.get(0));
                break;
            }
            default: {
                predicateObjectMaps = new LinkedHashSet(b.predicateObjectMaps.size() < 0x40000000 ? 1 + b.predicateObjectMaps.size() + (b.predicateObjectMaps.size() - 3) / 3 : Integer.MAX_VALUE);
                predicateObjectMaps.addAll(b.predicateObjectMaps);
                predicateObjectMaps = Collections.unmodifiableSet(predicateObjectMaps);
            }
        }
        this.predicateObjectMaps = predicateObjectMaps;
    }

    @Generated
    public static CarmlTriplesMapBuilder<?, ?> builder() {
        return new CarmlTriplesMapBuilderImpl();
    }

    @Generated
    public CarmlTriplesMap() {
    }

    @Generated
    public void setLogicalSource(LogicalSource logicalSource) {
        this.logicalSource = logicalSource;
    }

    @Generated
    public void setSubjectMaps(Set<SubjectMap> subjectMaps) {
        this.subjectMaps = subjectMaps;
    }

    @Generated
    public void setPredicateObjectMaps(Set<PredicateObjectMap> predicateObjectMaps) {
        this.predicateObjectMaps = predicateObjectMaps;
    }

    @Generated
    private static final class CarmlTriplesMapBuilderImpl
    extends CarmlTriplesMapBuilder<CarmlTriplesMap, CarmlTriplesMapBuilderImpl> {
        @Generated
        private CarmlTriplesMapBuilderImpl() {
        }

        @Override
        @Generated
        protected CarmlTriplesMapBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public CarmlTriplesMap build() {
            return new CarmlTriplesMap(this);
        }
    }

    @Generated
    public static abstract class CarmlTriplesMapBuilder<C extends CarmlTriplesMap, B extends CarmlTriplesMapBuilder<C, B>>
    extends CarmlResource.CarmlResourceBuilder<C, B> {
        @Generated
        private LogicalSource logicalSource;
        @Generated
        private ArrayList<SubjectMap> subjectMaps;
        @Generated
        private ArrayList<PredicateObjectMap> predicateObjectMaps;

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Generated
        public B logicalSource(LogicalSource logicalSource) {
            this.logicalSource = logicalSource;
            return (B)this.self();
        }

        @Generated
        public B subjectMap(SubjectMap subjectMap) {
            if (this.subjectMaps == null) {
                this.subjectMaps = new ArrayList();
            }
            this.subjectMaps.add(subjectMap);
            return (B)this.self();
        }

        @Generated
        public B subjectMaps(Collection<? extends SubjectMap> subjectMaps) {
            if (subjectMaps == null) {
                throw new NullPointerException("subjectMaps cannot be null");
            }
            if (this.subjectMaps == null) {
                this.subjectMaps = new ArrayList();
            }
            this.subjectMaps.addAll(subjectMaps);
            return (B)this.self();
        }

        @Generated
        public B clearSubjectMaps() {
            if (this.subjectMaps != null) {
                this.subjectMaps.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B predicateObjectMap(PredicateObjectMap predicateObjectMap) {
            if (this.predicateObjectMaps == null) {
                this.predicateObjectMaps = new ArrayList();
            }
            this.predicateObjectMaps.add(predicateObjectMap);
            return (B)this.self();
        }

        @Generated
        public B predicateObjectMaps(Collection<? extends PredicateObjectMap> predicateObjectMaps) {
            if (predicateObjectMaps == null) {
                throw new NullPointerException("predicateObjectMaps cannot be null");
            }
            if (this.predicateObjectMaps == null) {
                this.predicateObjectMaps = new ArrayList();
            }
            this.predicateObjectMaps.addAll(predicateObjectMaps);
            return (B)this.self();
        }

        @Generated
        public B clearPredicateObjectMaps() {
            if (this.predicateObjectMaps != null) {
                this.predicateObjectMaps.clear();
            }
            return (B)this.self();
        }

        @Override
        @Generated
        public String toString() {
            return "CarmlTriplesMap.CarmlTriplesMapBuilder(super=" + super.toString() + ", logicalSource=" + this.logicalSource + ", subjectMaps=" + this.subjectMaps + ", predicateObjectMaps=" + this.predicateObjectMaps + ")";
        }
    }
}

