/*
 * Decompiled with CFR 0.152.
 */
package io.carml.model.impl;

import com.google.common.collect.ImmutableSet;
import io.carml.model.GraphMap;
import io.carml.model.Resource;
import io.carml.model.SubjectMap;
import io.carml.model.impl.CarmlGraphMap;
import io.carml.model.impl.CarmlTermMap;
import io.carml.rdfmapper.annotations.RdfProperty;
import io.carml.rdfmapper.annotations.RdfType;
import io.carml.vocab.Rdf;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import lombok.Generated;
import org.apache.commons.lang3.builder.MultilineRecursiveToStringStyle;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.util.ModelBuilder;
import org.eclipse.rdf4j.model.vocabulary.RDF;

public class CarmlSubjectMap
extends CarmlTermMap
implements SubjectMap {
    private Set<IRI> classes;
    private Set<GraphMap> graphMaps;

    @Override
    @RdfProperty(value="http://www.w3.org/ns/r2rml#graphMap")
    @RdfType(value=CarmlGraphMap.class)
    public Set<GraphMap> getGraphMaps() {
        return this.graphMaps;
    }

    public void setGraphMaps(Set<GraphMap> graphMaps) {
        this.graphMaps = graphMaps;
    }

    @Override
    @RdfProperty(value="http://www.w3.org/ns/r2rml#class")
    public Set<IRI> getClasses() {
        return this.classes;
    }

    public void setClasses(Set<IRI> classes) {
        this.classes = classes;
    }

    public String toString() {
        return new ReflectionToStringBuilder((Object)this, (ToStringStyle)new MultilineRecursiveToStringStyle()).toString();
    }

    @Override
    public Set<Resource> getReferencedResources() {
        return ImmutableSet.builder().addAll(this.getReferencedResourcesBase()).addAll(this.graphMaps).build();
    }

    @Override
    public void addTriples(ModelBuilder modelBuilder) {
        modelBuilder.subject(this.getAsResource()).add(RDF.TYPE, (Object)Rdf.Rr.SubjectMap);
        this.addTriplesBase(modelBuilder);
        this.graphMaps.forEach(gm -> modelBuilder.add("http://www.w3.org/ns/r2rml#graphMap", (Object)gm.getAsResource()));
        this.classes.forEach(cl -> modelBuilder.add("http://www.w3.org/ns/r2rml#class", cl));
    }

    @Generated
    protected CarmlSubjectMap(CarmlSubjectMapBuilder<?, ?> b) {
        super((CarmlTermMap.CarmlTermMapBuilder<?, ?>)b);
        Set<Object> graphMaps;
        Set<Object> classes;
        switch (b.classes == null ? 0 : b.classes.size()) {
            case 0: {
                classes = Collections.emptySet();
                break;
            }
            case 1: {
                classes = Collections.singleton(b.classes.get(0));
                break;
            }
            default: {
                classes = new LinkedHashSet(b.classes.size() < 0x40000000 ? 1 + b.classes.size() + (b.classes.size() - 3) / 3 : Integer.MAX_VALUE);
                classes.addAll(b.classes);
                classes = Collections.unmodifiableSet(classes);
            }
        }
        this.classes = classes;
        switch (b.graphMaps == null ? 0 : b.graphMaps.size()) {
            case 0: {
                graphMaps = Collections.emptySet();
                break;
            }
            case 1: {
                graphMaps = Collections.singleton(b.graphMaps.get(0));
                break;
            }
            default: {
                graphMaps = new LinkedHashSet(b.graphMaps.size() < 0x40000000 ? 1 + b.graphMaps.size() + (b.graphMaps.size() - 3) / 3 : Integer.MAX_VALUE);
                graphMaps.addAll(b.graphMaps);
                graphMaps = Collections.unmodifiableSet(graphMaps);
            }
        }
        this.graphMaps = graphMaps;
    }

    @Generated
    public static CarmlSubjectMapBuilder<?, ?> builder() {
        return new CarmlSubjectMapBuilderImpl();
    }

    @Generated
    public CarmlSubjectMap() {
    }

    @Generated
    private static final class CarmlSubjectMapBuilderImpl
    extends CarmlSubjectMapBuilder<CarmlSubjectMap, CarmlSubjectMapBuilderImpl> {
        @Generated
        private CarmlSubjectMapBuilderImpl() {
        }

        @Override
        @Generated
        protected CarmlSubjectMapBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public CarmlSubjectMap build() {
            return new CarmlSubjectMap(this);
        }
    }

    @Generated
    public static abstract class CarmlSubjectMapBuilder<C extends CarmlSubjectMap, B extends CarmlSubjectMapBuilder<C, B>>
    extends CarmlTermMap.CarmlTermMapBuilder<C, B> {
        @Generated
        private ArrayList<IRI> classes;
        @Generated
        private ArrayList<GraphMap> graphMaps;

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Generated
        public B clazz(IRI clazz) {
            if (this.classes == null) {
                this.classes = new ArrayList();
            }
            this.classes.add(clazz);
            return (B)this.self();
        }

        @Generated
        public B classes(Collection<? extends IRI> classes) {
            if (classes == null) {
                throw new NullPointerException("classes cannot be null");
            }
            if (this.classes == null) {
                this.classes = new ArrayList();
            }
            this.classes.addAll(classes);
            return (B)this.self();
        }

        @Generated
        public B clearClasses() {
            if (this.classes != null) {
                this.classes.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B graphMap(GraphMap graphMap) {
            if (this.graphMaps == null) {
                this.graphMaps = new ArrayList();
            }
            this.graphMaps.add(graphMap);
            return (B)this.self();
        }

        @Generated
        public B graphMaps(Collection<? extends GraphMap> graphMaps) {
            if (graphMaps == null) {
                throw new NullPointerException("graphMaps cannot be null");
            }
            if (this.graphMaps == null) {
                this.graphMaps = new ArrayList();
            }
            this.graphMaps.addAll(graphMaps);
            return (B)this.self();
        }

        @Generated
        public B clearGraphMaps() {
            if (this.graphMaps != null) {
                this.graphMaps.clear();
            }
            return (B)this.self();
        }

        @Override
        @Generated
        public String toString() {
            return "CarmlSubjectMap.CarmlSubjectMapBuilder(super=" + super.toString() + ", classes=" + this.classes + ", graphMaps=" + this.graphMaps + ")";
        }
    }
}

