/*
 * Decompiled with CFR 0.152.
 */
package io.carml.model.impl;

import io.carml.model.Resource;
import io.carml.rdfmapper.annotations.RdfProperty;
import io.carml.rdfmapper.annotations.RdfResourceName;
import io.carml.util.RdfValues;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.model.util.ModelBuilder;
import org.eclipse.rdf4j.model.util.ModelCollector;
import org.eclipse.rdf4j.model.vocabulary.RDFS;

public abstract class CarmlResource
implements Resource {
    private static final ValueFactory VF = SimpleValueFactory.getInstance();
    String id;
    String label;
    private Map<Resource, Model> modelCache;

    CarmlResource(String id, String label) {
        this.id = id;
        this.label = label;
    }

    @Override
    @RdfResourceName
    public String getId() {
        return this.id;
    }

    @Override
    @RdfProperty(value="http://www.w3.org/2000/01/rdf-schema#label")
    public String getLabel() {
        return this.label;
    }

    @Override
    public org.eclipse.rdf4j.model.Resource getAsResource() {
        if (this.id == null) {
            return VF.createBNode();
        }
        if (RdfValues.isValidIri((String)this.id)) {
            return VF.createIRI(this.id);
        }
        return VF.createBNode(this.id);
    }

    private void cacheModel(Model model) {
        this.modelCache = new HashMap<Resource, Model>();
        this.modelCache.put(this, model);
    }

    @Override
    public Model asRdf() {
        Model cachedModel;
        if (this.modelCache.containsKey(this) && !(cachedModel = this.modelCache.get(this)).isEmpty()) {
            return cachedModel;
        }
        ModelBuilder builder = new ModelBuilder();
        this.addTriples(builder);
        if (this.label != null) {
            builder.add(RDFS.LABEL, (Object)this.label);
        }
        Model model = builder.build();
        Model nestedModel = (Model)this.getReferencedResources().stream().flatMap(resource -> resource.asRdf().stream()).collect(ModelCollector.toModel());
        model.addAll((Collection)nestedModel);
        this.cacheModel(model);
        return model;
    }

    @Generated
    private static Map<Resource, Model> $default$modelCache() {
        return new HashMap<Resource, Model>();
    }

    @Generated
    protected CarmlResource(CarmlResourceBuilder<?, ?> b) {
        this.id = b.id;
        this.label = b.label;
        this.modelCache = b.modelCache$set ? b.modelCache$value : CarmlResource.$default$modelCache();
    }

    @Generated
    public CarmlResource() {
        this.modelCache = CarmlResource.$default$modelCache();
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setLabel(String label) {
        this.label = label;
    }

    @Generated
    public static abstract class CarmlResourceBuilder<C extends CarmlResource, B extends CarmlResourceBuilder<C, B>> {
        @Generated
        private String id;
        @Generated
        private String label;
        @Generated
        private boolean modelCache$set;
        @Generated
        private Map<Resource, Model> modelCache$value;

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public B id(String id) {
            this.id = id;
            return this.self();
        }

        @Generated
        public B label(String label) {
            this.label = label;
            return this.self();
        }

        @Generated
        public B modelCache(Map<Resource, Model> modelCache) {
            this.modelCache$value = modelCache;
            this.modelCache$set = true;
            return this.self();
        }

        @Generated
        public String toString() {
            return "CarmlResource.CarmlResourceBuilder(id=" + this.id + ", label=" + this.label + ", modelCache$value=" + this.modelCache$value + ")";
        }
    }
}

