/*
 * Decompiled with CFR 0.152.
 */
package io.carml.model.impl;

import com.google.common.collect.ImmutableSet;
import io.carml.model.Join;
import io.carml.model.RefObjectMap;
import io.carml.model.Resource;
import io.carml.model.TriplesMap;
import io.carml.model.impl.CarmlJoin;
import io.carml.model.impl.CarmlResource;
import io.carml.model.impl.CarmlTriplesMap;
import io.carml.rdfmapper.annotations.RdfProperties;
import io.carml.rdfmapper.annotations.RdfProperty;
import io.carml.rdfmapper.annotations.RdfType;
import io.carml.vocab.Rdf;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import lombok.Generated;
import org.apache.commons.lang3.builder.MultilineRecursiveToStringStyle;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.eclipse.rdf4j.model.util.ModelBuilder;
import org.eclipse.rdf4j.model.vocabulary.RDF;

public class CarmlRefObjectMap
extends CarmlResource
implements RefObjectMap {
    private TriplesMap parentTriplesMap;
    private Set<Join> joinConditions;

    @Override
    @RdfProperty(value="http://www.w3.org/ns/r2rml#parentTriplesMap")
    @RdfType(value=CarmlTriplesMap.class)
    public TriplesMap getParentTriplesMap() {
        return this.parentTriplesMap;
    }

    @Override
    @RdfProperties(value={@RdfProperty(value="http://www.w3.org/ns/r2rml#joinCondition"), @RdfProperty(value="http://carml.taxonic.com/carml/multiJoinCondition", deprecated=true)})
    @RdfType(value=CarmlJoin.class)
    public Set<Join> getJoinConditions() {
        return this.joinConditions;
    }

    public String toString() {
        return new ReflectionToStringBuilder((Object)this, (ToStringStyle)new MultilineRecursiveToStringStyle()).toString();
    }

    @Override
    public Set<Resource> getReferencedResources() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        if (this.parentTriplesMap != null) {
            builder.add((Object)this.parentTriplesMap);
        }
        return builder.addAll(this.joinConditions).build();
    }

    @Override
    public void addTriples(ModelBuilder modelBuilder) {
        modelBuilder.subject(this.getAsResource()).add(RDF.TYPE, (Object)Rdf.Rr.RefObjectMap);
        if (this.parentTriplesMap != null) {
            modelBuilder.add("http://www.w3.org/ns/r2rml#parentTriplesMap", (Object)this.parentTriplesMap.getAsResource());
        }
        this.joinConditions.forEach(jc -> modelBuilder.add("http://www.w3.org/ns/r2rml#joinCondition", (Object)jc.getAsResource()));
    }

    @Generated
    protected CarmlRefObjectMap(CarmlRefObjectMapBuilder<?, ?> b) {
        super(b);
        Set<Object> joinConditions;
        this.parentTriplesMap = b.parentTriplesMap;
        switch (b.joinConditions == null ? 0 : b.joinConditions.size()) {
            case 0: {
                joinConditions = Collections.emptySet();
                break;
            }
            case 1: {
                joinConditions = Collections.singleton(b.joinConditions.get(0));
                break;
            }
            default: {
                joinConditions = new LinkedHashSet(b.joinConditions.size() < 0x40000000 ? 1 + b.joinConditions.size() + (b.joinConditions.size() - 3) / 3 : Integer.MAX_VALUE);
                joinConditions.addAll(b.joinConditions);
                joinConditions = Collections.unmodifiableSet(joinConditions);
            }
        }
        this.joinConditions = joinConditions;
    }

    @Generated
    public static CarmlRefObjectMapBuilder<?, ?> builder() {
        return new CarmlRefObjectMapBuilderImpl();
    }

    @Generated
    public CarmlRefObjectMap() {
    }

    @Generated
    public void setParentTriplesMap(TriplesMap parentTriplesMap) {
        this.parentTriplesMap = parentTriplesMap;
    }

    @Generated
    public void setJoinConditions(Set<Join> joinConditions) {
        this.joinConditions = joinConditions;
    }

    @Generated
    private static final class CarmlRefObjectMapBuilderImpl
    extends CarmlRefObjectMapBuilder<CarmlRefObjectMap, CarmlRefObjectMapBuilderImpl> {
        @Generated
        private CarmlRefObjectMapBuilderImpl() {
        }

        @Override
        @Generated
        protected CarmlRefObjectMapBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public CarmlRefObjectMap build() {
            return new CarmlRefObjectMap(this);
        }
    }

    @Generated
    public static abstract class CarmlRefObjectMapBuilder<C extends CarmlRefObjectMap, B extends CarmlRefObjectMapBuilder<C, B>>
    extends CarmlResource.CarmlResourceBuilder<C, B> {
        @Generated
        private TriplesMap parentTriplesMap;
        @Generated
        private ArrayList<Join> joinConditions;

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Generated
        public B parentTriplesMap(TriplesMap parentTriplesMap) {
            this.parentTriplesMap = parentTriplesMap;
            return (B)this.self();
        }

        @Generated
        public B joinCondition(Join joinCondition) {
            if (this.joinConditions == null) {
                this.joinConditions = new ArrayList();
            }
            this.joinConditions.add(joinCondition);
            return (B)this.self();
        }

        @Generated
        public B joinConditions(Collection<? extends Join> joinConditions) {
            if (joinConditions == null) {
                throw new NullPointerException("joinConditions cannot be null");
            }
            if (this.joinConditions == null) {
                this.joinConditions = new ArrayList();
            }
            this.joinConditions.addAll(joinConditions);
            return (B)this.self();
        }

        @Generated
        public B clearJoinConditions() {
            if (this.joinConditions != null) {
                this.joinConditions.clear();
            }
            return (B)this.self();
        }

        @Override
        @Generated
        public String toString() {
            return "CarmlRefObjectMap.CarmlRefObjectMapBuilder(super=" + super.toString() + ", parentTriplesMap=" + this.parentTriplesMap + ", joinConditions=" + this.joinConditions + ")";
        }
    }
}

