/*
 * Decompiled with CFR 0.152.
 */
package io.carml.model.impl;

import com.google.common.collect.ImmutableSet;
import io.carml.model.BaseObjectMap;
import io.carml.model.GraphMap;
import io.carml.model.PredicateMap;
import io.carml.model.PredicateObjectMap;
import io.carml.model.Resource;
import io.carml.model.impl.CarmlGraphMap;
import io.carml.model.impl.CarmlPredicateMap;
import io.carml.model.impl.CarmlResource;
import io.carml.model.impl.ObjectMapTypeDecider;
import io.carml.rdfmapper.annotations.RdfProperty;
import io.carml.rdfmapper.annotations.RdfType;
import io.carml.rdfmapper.annotations.RdfTypeDecider;
import io.carml.vocab.Rdf;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import lombok.Generated;
import org.apache.commons.lang3.builder.MultilineRecursiveToStringStyle;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.eclipse.rdf4j.model.util.ModelBuilder;
import org.eclipse.rdf4j.model.vocabulary.RDF;

public class CarmlPredicateObjectMap
extends CarmlResource
implements PredicateObjectMap {
    private Set<PredicateMap> predicateMaps;
    private Set<BaseObjectMap> objectMaps;
    private Set<GraphMap> graphMaps;

    @Override
    @RdfProperty(value="http://www.w3.org/ns/r2rml#predicateMap")
    @RdfType(value=CarmlPredicateMap.class)
    public Set<PredicateMap> getPredicateMaps() {
        return this.predicateMaps;
    }

    @Override
    @RdfProperty(value="http://www.w3.org/ns/r2rml#objectMap")
    @RdfTypeDecider(value=ObjectMapTypeDecider.class)
    public Set<BaseObjectMap> getObjectMaps() {
        return this.objectMaps;
    }

    @Override
    @RdfProperty(value="http://www.w3.org/ns/r2rml#graphMap")
    @RdfType(value=CarmlGraphMap.class)
    public Set<GraphMap> getGraphMaps() {
        return this.graphMaps;
    }

    public String toString() {
        return new ReflectionToStringBuilder((Object)this, (ToStringStyle)new MultilineRecursiveToStringStyle()).toString();
    }

    @Override
    public Set<Resource> getReferencedResources() {
        return ImmutableSet.builder().addAll(this.predicateMaps).addAll(this.objectMaps).addAll(this.graphMaps).build();
    }

    @Override
    public void addTriples(ModelBuilder modelBuilder) {
        modelBuilder.subject(this.getAsResource()).add(RDF.TYPE, (Object)Rdf.Rr.PredicateObjectMap);
        this.predicateMaps.forEach(pm -> modelBuilder.add("http://www.w3.org/ns/r2rml#predicateMap", (Object)pm.getAsResource()));
        this.objectMaps.forEach(om -> modelBuilder.add("http://www.w3.org/ns/r2rml#objectMap", (Object)om.getAsResource()));
        this.graphMaps.forEach(gm -> modelBuilder.add("http://www.w3.org/ns/r2rml#graphMap", (Object)gm.getAsResource()));
    }

    @Generated
    protected CarmlPredicateObjectMap(CarmlPredicateObjectMapBuilder<?, ?> b) {
        super(b);
        Set<Object> graphMaps;
        Set<Object> objectMaps;
        Set<Object> predicateMaps;
        switch (b.predicateMaps == null ? 0 : b.predicateMaps.size()) {
            case 0: {
                predicateMaps = Collections.emptySet();
                break;
            }
            case 1: {
                predicateMaps = Collections.singleton(b.predicateMaps.get(0));
                break;
            }
            default: {
                predicateMaps = new LinkedHashSet(b.predicateMaps.size() < 0x40000000 ? 1 + b.predicateMaps.size() + (b.predicateMaps.size() - 3) / 3 : Integer.MAX_VALUE);
                predicateMaps.addAll(b.predicateMaps);
                predicateMaps = Collections.unmodifiableSet(predicateMaps);
            }
        }
        this.predicateMaps = predicateMaps;
        switch (b.objectMaps == null ? 0 : b.objectMaps.size()) {
            case 0: {
                objectMaps = Collections.emptySet();
                break;
            }
            case 1: {
                objectMaps = Collections.singleton(b.objectMaps.get(0));
                break;
            }
            default: {
                objectMaps = new LinkedHashSet(b.objectMaps.size() < 0x40000000 ? 1 + b.objectMaps.size() + (b.objectMaps.size() - 3) / 3 : Integer.MAX_VALUE);
                objectMaps.addAll(b.objectMaps);
                objectMaps = Collections.unmodifiableSet(objectMaps);
            }
        }
        this.objectMaps = objectMaps;
        switch (b.graphMaps == null ? 0 : b.graphMaps.size()) {
            case 0: {
                graphMaps = Collections.emptySet();
                break;
            }
            case 1: {
                graphMaps = Collections.singleton(b.graphMaps.get(0));
                break;
            }
            default: {
                graphMaps = new LinkedHashSet(b.graphMaps.size() < 0x40000000 ? 1 + b.graphMaps.size() + (b.graphMaps.size() - 3) / 3 : Integer.MAX_VALUE);
                graphMaps.addAll(b.graphMaps);
                graphMaps = Collections.unmodifiableSet(graphMaps);
            }
        }
        this.graphMaps = graphMaps;
    }

    @Generated
    public static CarmlPredicateObjectMapBuilder<?, ?> builder() {
        return new CarmlPredicateObjectMapBuilderImpl();
    }

    @Generated
    public CarmlPredicateObjectMap() {
    }

    @Generated
    public void setPredicateMaps(Set<PredicateMap> predicateMaps) {
        this.predicateMaps = predicateMaps;
    }

    @Generated
    public void setObjectMaps(Set<BaseObjectMap> objectMaps) {
        this.objectMaps = objectMaps;
    }

    @Generated
    public void setGraphMaps(Set<GraphMap> graphMaps) {
        this.graphMaps = graphMaps;
    }

    @Generated
    private static final class CarmlPredicateObjectMapBuilderImpl
    extends CarmlPredicateObjectMapBuilder<CarmlPredicateObjectMap, CarmlPredicateObjectMapBuilderImpl> {
        @Generated
        private CarmlPredicateObjectMapBuilderImpl() {
        }

        @Override
        @Generated
        protected CarmlPredicateObjectMapBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public CarmlPredicateObjectMap build() {
            return new CarmlPredicateObjectMap(this);
        }
    }

    @Generated
    public static abstract class CarmlPredicateObjectMapBuilder<C extends CarmlPredicateObjectMap, B extends CarmlPredicateObjectMapBuilder<C, B>>
    extends CarmlResource.CarmlResourceBuilder<C, B> {
        @Generated
        private ArrayList<PredicateMap> predicateMaps;
        @Generated
        private ArrayList<BaseObjectMap> objectMaps;
        @Generated
        private ArrayList<GraphMap> graphMaps;

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Generated
        public B predicateMap(PredicateMap predicateMap) {
            if (this.predicateMaps == null) {
                this.predicateMaps = new ArrayList();
            }
            this.predicateMaps.add(predicateMap);
            return (B)this.self();
        }

        @Generated
        public B predicateMaps(Collection<? extends PredicateMap> predicateMaps) {
            if (predicateMaps == null) {
                throw new NullPointerException("predicateMaps cannot be null");
            }
            if (this.predicateMaps == null) {
                this.predicateMaps = new ArrayList();
            }
            this.predicateMaps.addAll(predicateMaps);
            return (B)this.self();
        }

        @Generated
        public B clearPredicateMaps() {
            if (this.predicateMaps != null) {
                this.predicateMaps.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B objectMap(BaseObjectMap objectMap) {
            if (this.objectMaps == null) {
                this.objectMaps = new ArrayList();
            }
            this.objectMaps.add(objectMap);
            return (B)this.self();
        }

        @Generated
        public B objectMaps(Collection<? extends BaseObjectMap> objectMaps) {
            if (objectMaps == null) {
                throw new NullPointerException("objectMaps cannot be null");
            }
            if (this.objectMaps == null) {
                this.objectMaps = new ArrayList();
            }
            this.objectMaps.addAll(objectMaps);
            return (B)this.self();
        }

        @Generated
        public B clearObjectMaps() {
            if (this.objectMaps != null) {
                this.objectMaps.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B graphMap(GraphMap graphMap) {
            if (this.graphMaps == null) {
                this.graphMaps = new ArrayList();
            }
            this.graphMaps.add(graphMap);
            return (B)this.self();
        }

        @Generated
        public B graphMaps(Collection<? extends GraphMap> graphMaps) {
            if (graphMaps == null) {
                throw new NullPointerException("graphMaps cannot be null");
            }
            if (this.graphMaps == null) {
                this.graphMaps = new ArrayList();
            }
            this.graphMaps.addAll(graphMaps);
            return (B)this.self();
        }

        @Generated
        public B clearGraphMaps() {
            if (this.graphMaps != null) {
                this.graphMaps.clear();
            }
            return (B)this.self();
        }

        @Override
        @Generated
        public String toString() {
            return "CarmlPredicateObjectMap.CarmlPredicateObjectMapBuilder(super=" + super.toString() + ", predicateMaps=" + this.predicateMaps + ", objectMaps=" + this.objectMaps + ", graphMaps=" + this.graphMaps + ")";
        }
    }
}

