/*
 * Decompiled with CFR 0.152.
 */
package io.carml.model.impl;

import io.carml.model.ExpressionMap;
import io.carml.model.Resource;
import io.carml.model.TriplesMap;
import io.carml.model.impl.CarmlResource;
import io.carml.model.impl.CarmlTriplesMap;
import io.carml.rdfmapper.annotations.RdfProperties;
import io.carml.rdfmapper.annotations.RdfProperty;
import io.carml.rdfmapper.annotations.RdfType;
import java.util.Set;
import lombok.Generated;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.util.ModelBuilder;

abstract class CarmlExpressionMap
extends CarmlResource
implements ExpressionMap {
    String reference;
    String template;
    Value constant;
    TriplesMap functionValue;

    CarmlExpressionMap(String id, String label, String reference, String template, Value constant, TriplesMap functionValue) {
        super(id, label);
        this.reference = reference;
        this.template = template;
        this.constant = constant;
        this.functionValue = functionValue;
    }

    @Override
    @RdfProperties(value={@RdfProperty(value="http://semweb.mmlab.be/ns/rml#reference"), @RdfProperty(value="http://carml.taxonic.com/carml/multiReference", deprecated=true)})
    public String getReference() {
        return this.reference;
    }

    @Override
    @RdfProperties(value={@RdfProperty(value="http://www.w3.org/ns/r2rml#template"), @RdfProperty(value="http://carml.taxonic.com/carml/multiTemplate", deprecated=true)})
    public String getTemplate() {
        return this.template;
    }

    @Override
    @RdfProperty(value="http://www.w3.org/ns/r2rml#constant")
    public Value getConstant() {
        return this.constant;
    }

    @Override
    @RdfProperties(value={@RdfProperty(value="http://semweb.mmlab.be/ns/fnml#functionValue"), @RdfProperty(value="http://carml.taxonic.com/carml/multiFunctionValue", deprecated=true)})
    @RdfType(value=CarmlTriplesMap.class)
    public TriplesMap getFunctionValue() {
        return this.functionValue;
    }

    Set<Resource> getReferencedResourcesBase() {
        return this.functionValue != null ? Set.of(this.functionValue) : Set.of();
    }

    void addTriplesBase(ModelBuilder builder) {
        if (this.reference != null) {
            builder.add("http://semweb.mmlab.be/ns/rml#reference", (Object)this.reference);
        }
        if (this.template != null) {
            builder.add("http://www.w3.org/ns/r2rml#template", (Object)this.template);
        }
        if (this.constant != null) {
            builder.add("http://www.w3.org/ns/r2rml#constant", (Object)this.constant);
        }
        if (this.functionValue != null) {
            builder.add("http://semweb.mmlab.be/ns/fnml#functionValue", (Object)this.functionValue.getAsResource());
        }
    }

    @Generated
    protected CarmlExpressionMap(CarmlExpressionMapBuilder<?, ?> b) {
        super(b);
        this.reference = b.reference;
        this.template = b.template;
        this.constant = b.constant;
        this.functionValue = b.functionValue;
    }

    @Generated
    CarmlExpressionMap() {
    }

    @Generated
    public void setReference(String reference) {
        this.reference = reference;
    }

    @Generated
    public void setTemplate(String template) {
        this.template = template;
    }

    @Generated
    public void setConstant(Value constant) {
        this.constant = constant;
    }

    @Generated
    public void setFunctionValue(TriplesMap functionValue) {
        this.functionValue = functionValue;
    }

    @Generated
    public static abstract class CarmlExpressionMapBuilder<C extends CarmlExpressionMap, B extends CarmlExpressionMapBuilder<C, B>>
    extends CarmlResource.CarmlResourceBuilder<C, B> {
        @Generated
        private String reference;
        @Generated
        private String template;
        @Generated
        private Value constant;
        @Generated
        private TriplesMap functionValue;

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Generated
        public B reference(String reference) {
            this.reference = reference;
            return (B)this.self();
        }

        @Generated
        public B template(String template) {
            this.template = template;
            return (B)this.self();
        }

        @Generated
        public B constant(Value constant) {
            this.constant = constant;
            return (B)this.self();
        }

        @Generated
        public B functionValue(TriplesMap functionValue) {
            this.functionValue = functionValue;
            return (B)this.self();
        }

        @Override
        @Generated
        public String toString() {
            return "CarmlExpressionMap.CarmlExpressionMapBuilder(super=" + super.toString() + ", reference=" + this.reference + ", template=" + this.template + ", constant=" + this.constant + ", functionValue=" + this.functionValue + ")";
        }
    }
}

