/*
 * Decompiled with CFR 0.152.
 */
package io.carml.logicalsourceresolver;

import io.carml.logicalsourceresolver.LogicalSourceRecord;
import io.carml.logicalsourceresolver.LogicalSourceResolver;
import io.carml.logicalsourceresolver.LogicalSourceResolverException;
import io.carml.logicalsourceresolver.PausableStaxXmlReader;
import io.carml.logicalsourceresolver.ResolvedSource;
import io.carml.model.LogicalSource;
import io.carml.model.XmlSource;
import io.carml.util.LogUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.xml.namespace.NamespaceContext;
import javax.xml.stream.XMLStreamException;
import javax.xml.xpath.XPathException;
import jlibs.xml.DefaultNamespaceContext;
import jlibs.xml.sax.dog.NodeItem;
import jlibs.xml.sax.dog.XMLDog;
import jlibs.xml.sax.dog.expr.EvaluationListener;
import jlibs.xml.sax.dog.expr.Expression;
import jlibs.xml.sax.dog.expr.InstantEvaluationListener;
import jlibs.xml.sax.dog.sniff.DOMBuilder;
import jlibs.xml.sax.dog.sniff.Event;
import jlibs.xml.sax.dog.sniff.XMLBuilder;
import lombok.Generated;
import net.sf.saxon.s9api.DocumentBuilder;
import net.sf.saxon.s9api.Processor;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XPathCompiler;
import net.sf.saxon.s9api.XPathSelector;
import net.sf.saxon.s9api.XdmItem;
import net.sf.saxon.s9api.XdmValue;
import org.jaxen.saxpath.SAXPathException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import reactor.core.publisher.Flux;
import reactor.core.publisher.FluxSink;

public class XPathResolver
implements LogicalSourceResolver<XdmItem> {
    @Generated
    private static final Logger LOG = LoggerFactory.getLogger(XPathResolver.class);
    private final DefaultNamespaceContext nsContext;
    private final Processor xpathProcessor;
    private final XPathCompiler xpathCompiler;
    private final boolean autoNodeTextExtraction;
    private final Map<Set<LogicalSource>, XMLDog> xmlDogCache;

    public static XPathResolver getInstance() {
        return XPathResolver.getInstance(true);
    }

    public static XPathResolver getInstance(boolean autoNodeTextExtraction) {
        Processor processor = new Processor(false);
        XPathCompiler compiler = processor.newXPathCompiler();
        compiler.setCaching(true);
        return XPathResolver.getInstance(processor, compiler, autoNodeTextExtraction);
    }

    public static XPathResolver getInstance(Processor xpathProcessor, XPathCompiler xpathCompiler, boolean autoNodeTextExtraction) {
        return new XPathResolver(new DefaultNamespaceContext(), xpathProcessor, xpathCompiler, autoNodeTextExtraction, new HashMap<Set<LogicalSource>, XMLDog>());
    }

    private void setNamespaces(LogicalSource logicalSource) {
        Object source = logicalSource.getSource();
        if (source instanceof XmlSource) {
            ((XmlSource)source).getDeclaredNamespaces().forEach(n -> {
                this.nsContext.declarePrefix(n.getPrefix(), n.getName());
                this.xpathCompiler.declareNamespace(n.getPrefix(), n.getName());
            });
        }
    }

    public Function<ResolvedSource<?>, Flux<LogicalSourceRecord<XdmItem>>> getLogicalSourceRecords(Set<LogicalSource> logicalSources) {
        return resolvedSource -> this.getLogicalSourceRecordFlux((ResolvedSource<?>)resolvedSource, logicalSources);
    }

    private Flux<LogicalSourceRecord<XdmItem>> getLogicalSourceRecordFlux(ResolvedSource<?> resolvedSource, Set<LogicalSource> logicalSources) {
        if (logicalSources.isEmpty()) {
            throw new IllegalStateException("No logical sources registered");
        }
        if (resolvedSource == null || resolvedSource.getResolved().isEmpty()) {
            throw new LogicalSourceResolverException(String.format("No source provided for logical sources:%n%s", LogUtil.exception(logicalSources)));
        }
        Object resolved = resolvedSource.getResolved().get();
        if (resolved instanceof InputStream) {
            return this.getXpathResultFlux((InputStream)resolvedSource.getResolved().get(), logicalSources);
        }
        if (resolved instanceof XdmItem) {
            return this.getXpathResultFlux((XdmItem)resolved, logicalSources);
        }
        throw new LogicalSourceResolverException(String.format("Unsupported source object provided for logical sources:%n%s", LogUtil.exception(logicalSources)));
    }

    private Flux<LogicalSourceRecord<XdmItem>> getXpathResultFlux(InputStream inputStream, Set<LogicalSource> logicalSources) {
        AtomicLong outstandingRequests = new AtomicLong();
        PausableStaxXmlReader pausableReader = new PausableStaxXmlReader();
        return Flux.create(sink -> this.xpathPathFlux((FluxSink<LogicalSourceRecord<XdmItem>>)sink, logicalSources, inputStream, outstandingRequests, pausableReader));
    }

    private Flux<LogicalSourceRecord<XdmItem>> getXpathResultFlux(XdmItem xdmItem, Set<LogicalSource> logicalSources) {
        return Flux.fromIterable(logicalSources).flatMap(logicalSource -> this.getXpathResultFluxForLogicalSource(xdmItem, (LogicalSource)logicalSource));
    }

    private void xpathPathFlux(FluxSink<LogicalSourceRecord<XdmItem>> sink, Set<LogicalSource> logicalSources, InputStream inputStream, AtomicLong outstandingRequests, PausableStaxXmlReader pausableReader) {
        sink.onRequest(requested -> {
            long outstanding = outstandingRequests.addAndGet(requested);
            if (pausableReader.isPaused() && outstanding >= 0L) {
                if (!pausableReader.isCompleted()) {
                    try {
                        pausableReader.resume();
                    }
                    catch (XMLStreamException | SAXException xmlReadingException) {
                        sink.error((Throwable)new LogicalSourceResolverException("Error reading XML source.", (Throwable)xmlReadingException));
                    }
                }
            } else {
                this.checkReaderToPause(outstanding, pausableReader);
            }
        });
        sink.onDispose(() -> this.cleanup(inputStream));
        HashMap<String, LogicalSource> logicalSourceByExpression = new HashMap<String, LogicalSource>();
        XMLDog xmlDog = this.prepareXmlDog(sink, logicalSources, logicalSourceByExpression);
        Event event = xmlDog.createEvent();
        this.bridgeAndListen(logicalSourceByExpression, event, sink, outstandingRequests, pausableReader);
        try {
            xmlDog.sniff(event, new InputSource(inputStream), (XMLReader)((Object)pausableReader));
        }
        catch (XPathException xpathException) {
            sink.error((Throwable)new LogicalSourceResolverException("Error executing XPath expression.", (Throwable)xpathException));
        }
    }

    private XMLDog prepareXmlDog(FluxSink<LogicalSourceRecord<XdmItem>> sink, Set<LogicalSource> logicalSources, Map<String, LogicalSource> logicalSourceByExpression) {
        XMLDog xmlDog;
        if (this.xmlDogCache.containsKey(logicalSources)) {
            xmlDog = this.xmlDogCache.get(logicalSources);
            logicalSources.forEach(logicalSource -> logicalSourceByExpression.put(logicalSource.getIterator(), (LogicalSource)logicalSource));
        } else {
            xmlDog = new XMLDog((NamespaceContext)this.nsContext);
            logicalSources.forEach(logicalSource -> {
                this.setNamespaces((LogicalSource)logicalSource);
                try {
                    String expression = logicalSource.getIterator();
                    xmlDog.addXPath(expression);
                    logicalSourceByExpression.put(expression, (LogicalSource)logicalSource);
                }
                catch (SAXPathException saxPathException) {
                    sink.error((Throwable)new LogicalSourceResolverException(String.format("Error parsing XPath expression: %s", logicalSource.getIterator()), (Throwable)saxPathException));
                }
            });
            this.xmlDogCache.put(logicalSources, xmlDog);
        }
        return xmlDog;
    }

    private void bridgeAndListen(final Map<String, LogicalSource> logicalSourceByExpression, Event event, final FluxSink<LogicalSourceRecord<XdmItem>> sink, final AtomicLong outstandingRequests, final PausableStaxXmlReader pausableReader) {
        final Map<String, Boolean> expressionCompletion = logicalSourceByExpression.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> false));
        event.setXMLBuilder((XMLBuilder)new DOMBuilder());
        event.setListener((EvaluationListener)new InstantEvaluationListener(){
            private final DocumentBuilder docBuilder;
            {
                this.docBuilder = XPathResolver.this.xpathProcessor.newDocumentBuilder();
            }

            public void onNodeHit(Expression expression, NodeItem nodeItem) {
                LogicalSource logicalSource = (LogicalSource)logicalSourceByExpression.get(expression.getXPath());
                sink.next((Object)LogicalSourceRecord.of((LogicalSource)logicalSource, (Object)this.docBuilder.wrap(nodeItem.xml)));
                long outstanding = outstandingRequests.decrementAndGet();
                XPathResolver.this.checkReaderToPause(outstanding, pausableReader);
            }

            public void finishedNodeSet(Expression expression) {
                expressionCompletion.put(expression.getXPath(), true);
                if (expressionCompletion.values().stream().allMatch(Boolean::valueOf)) {
                    sink.complete();
                }
            }

            public void onResult(Expression expression, Object o) {
                LogicalSource logicalSource = (LogicalSource)logicalSourceByExpression.get(expression.getXPath());
                sink.next((Object)LogicalSourceRecord.of((LogicalSource)logicalSource, (Object)this.docBuilder.wrap(o)));
                long outstanding = outstandingRequests.decrementAndGet();
                XPathResolver.this.checkReaderToPause(outstanding, pausableReader);
            }
        });
    }

    private void checkReaderToPause(long outstanding, PausableStaxXmlReader pausableReader) {
        if (!pausableReader.isPaused() && outstanding < 0L) {
            pausableReader.pause();
        }
    }

    private void cleanup(InputStream inputStream) {
        try {
            inputStream.close();
        }
        catch (IOException ioException) {
            throw new LogicalSourceResolverException("Error closing input stream.", (Throwable)ioException);
        }
    }

    private Flux<LogicalSourceRecord<XdmItem>> getXpathResultFluxForLogicalSource(XdmItem xdmItem, LogicalSource logicalSource) {
        try {
            XPathSelector selector = this.xpathCompiler.compile(logicalSource.getIterator()).load();
            selector.setContextItem(xdmItem);
            XdmValue value = selector.evaluate();
            if (value.isEmpty()) {
                return Flux.empty();
            }
            return Flux.fromIterable((Iterable)value).map(item -> LogicalSourceRecord.of((LogicalSource)logicalSource, (Object)item));
        }
        catch (SaxonApiException e) {
            throw new LogicalSourceResolverException(String.format("Error applying XPath expression [%s] to entry [%s]", logicalSource.getIterator(), xdmItem), (Throwable)e);
        }
    }

    public LogicalSourceResolver.ExpressionEvaluationFactory<XdmItem> getExpressionEvaluationFactory() {
        return entry -> expression -> {
            this.logEvaluateExpression((String)expression, LOG);
            try {
                XPathSelector selector = this.xpathCompiler.compile(expression).load();
                selector.setContextItem(entry);
                XdmValue value = selector.evaluate();
                if (value.size() > 1) {
                    ArrayList results = new ArrayList();
                    value.forEach(item -> {
                        String stringValue = this.getItemStringValue((XdmItem)item, value);
                        if (stringValue != null) {
                            results.add(stringValue);
                        }
                    });
                    return Optional.of(results);
                }
                if (value.size() == 0) {
                    return Optional.empty();
                }
                XdmItem item2 = value.itemAt(0);
                return Optional.ofNullable(this.getItemStringValue(item2, value));
            }
            catch (SaxonApiException e) {
                throw new LogicalSourceResolverException(String.format("Error applying XPath expression [%s] to entry [%s]", expression, entry), (Throwable)e);
            }
        };
    }

    private String getItemStringValue(XdmItem item, XdmValue value) {
        if (item.getStringValue().length() == 0) {
            return null;
        }
        return this.autoNodeTextExtraction ? item.getStringValue() : value.toString();
    }

    @Generated
    private XPathResolver(DefaultNamespaceContext nsContext, Processor xpathProcessor, XPathCompiler xpathCompiler, boolean autoNodeTextExtraction, Map<Set<LogicalSource>, XMLDog> xmlDogCache) {
        this.nsContext = nsContext;
        this.xpathProcessor = xpathProcessor;
        this.xpathCompiler = xpathCompiler;
        this.autoNodeTextExtraction = autoNodeTextExtraction;
        this.xmlDogCache = xmlDogCache;
    }
}

