/*
 * Decompiled with CFR 0.152.
 */
package io.carml.logicalsourceresolver;

import io.carml.logicalsourceresolver.LogicalSourceRecord;
import io.carml.logicalsourceresolver.LogicalSourceResolver;
import io.carml.logicalsourceresolver.LogicalSourceResolverException;
import io.carml.logicalsourceresolver.PausableStaxXmlReader;
import io.carml.logicalsourceresolver.ResolvedSource;
import io.carml.model.LogicalSource;
import io.carml.model.XmlSource;
import io.carml.util.LogUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.xml.namespace.NamespaceContext;
import javax.xml.stream.XMLStreamException;
import javax.xml.xpath.XPathException;
import jlibs.xml.DefaultNamespaceContext;
import jlibs.xml.sax.dog.NodeItem;
import jlibs.xml.sax.dog.XMLDog;
import jlibs.xml.sax.dog.expr.EvaluationListener;
import jlibs.xml.sax.dog.expr.Expression;
import jlibs.xml.sax.dog.expr.InstantEvaluationListener;
import jlibs.xml.sax.dog.sniff.DOMBuilder;
import jlibs.xml.sax.dog.sniff.Event;
import jlibs.xml.sax.dog.sniff.XMLBuilder;
import lombok.Generated;
import net.sf.saxon.s9api.DocumentBuilder;
import net.sf.saxon.s9api.Processor;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XPathCompiler;
import net.sf.saxon.s9api.XPathSelector;
import net.sf.saxon.s9api.XdmItem;
import net.sf.saxon.s9api.XdmValue;
import org.jaxen.saxpath.SAXPathException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import reactor.core.publisher.Flux;
import reactor.core.publisher.FluxSink;

public class XPathResolver
implements LogicalSourceResolver<XdmItem> {
    @Generated
    private static final Logger LOG = LoggerFactory.getLogger(XPathResolver.class);
    private final DefaultNamespaceContext nsContext;
    private final XMLDog xmlDog;
    private final Processor xpathProcessor;
    private final XPathCompiler xpathCompiler;
    private final boolean autoNodeTextExtraction;

    public static XPathResolver getInstance() {
        return XPathResolver.getInstance(true);
    }

    public static XPathResolver getInstance(boolean autoNodeTextExtraction) {
        Processor processor = new Processor(false);
        XPathCompiler compiler = processor.newXPathCompiler();
        compiler.setCaching(true);
        XMLDog xmlDog = new XMLDog((NamespaceContext)new DefaultNamespaceContext());
        return XPathResolver.getInstance(xmlDog, processor, compiler, autoNodeTextExtraction);
    }

    public static XPathResolver getInstance(XMLDog xmlDog, Processor xpathProcessor, XPathCompiler xpathCompiler, boolean autoNodeTextExtraction) {
        DefaultNamespaceContext namespaceContext = !(xmlDog.nsContext instanceof DefaultNamespaceContext) ? new DefaultNamespaceContext() : (DefaultNamespaceContext)xmlDog.nsContext;
        return new XPathResolver(namespaceContext, xmlDog, xpathProcessor, xpathCompiler, autoNodeTextExtraction);
    }

    private void setNamespaces(LogicalSource logicalSource) {
        Object source = logicalSource.getSource();
        if (source instanceof XmlSource) {
            ((XmlSource)source).getDeclaredNamespaces().forEach(n -> {
                this.nsContext.declarePrefix(n.getPrefix(), n.getName());
                this.xpathCompiler.declareNamespace(n.getPrefix(), n.getName());
            });
        }
    }

    public Function<ResolvedSource<?>, Flux<LogicalSourceRecord<XdmItem>>> getLogicalSourceRecords(Set<LogicalSource> logicalSources) {
        return resolvedSource -> this.getLogicalSourceRecordFlux((ResolvedSource<?>)resolvedSource, logicalSources);
    }

    private Flux<LogicalSourceRecord<XdmItem>> getLogicalSourceRecordFlux(ResolvedSource<?> resolvedSource, Set<LogicalSource> logicalSources) {
        if (resolvedSource == null || resolvedSource.getResolved().isEmpty()) {
            throw new LogicalSourceResolverException(String.format("No source provided for logical sources:%n%s", LogUtil.exception(logicalSources)));
        }
        Object resolved = resolvedSource.getResolved().get();
        if (resolved instanceof InputStream) {
            return this.getXpathResultFlux((InputStream)resolvedSource.getResolved().get(), logicalSources);
        }
        if (resolved instanceof XdmItem) {
            return Flux.fromStream(logicalSources.stream().map(logicalSource -> LogicalSourceRecord.of((LogicalSource)logicalSource, (Object)((XdmItem)resolved))));
        }
        throw new LogicalSourceResolverException(String.format("Unsupported source object provided for logical sources:%n%s", LogUtil.exception(logicalSources)));
    }

    private Flux<LogicalSourceRecord<XdmItem>> getXpathResultFlux(InputStream inputStream, Set<LogicalSource> logicalSources) {
        if (logicalSources.isEmpty()) {
            throw new IllegalStateException("No logical sources registered");
        }
        AtomicLong outstandingRequests = new AtomicLong();
        PausableStaxXmlReader pausableReader = new PausableStaxXmlReader();
        return Flux.create(sink -> this.xpathPathFlux((FluxSink<LogicalSourceRecord<XdmItem>>)sink, logicalSources, inputStream, outstandingRequests, pausableReader));
    }

    private void xpathPathFlux(FluxSink<LogicalSourceRecord<XdmItem>> sink, Set<LogicalSource> logicalSources, InputStream inputStream, AtomicLong outstandingRequests, PausableStaxXmlReader pausableReader) {
        sink.onRequest(requested -> {
            long outstanding = outstandingRequests.addAndGet(requested);
            boolean paused = pausableReader.isPaused();
            if (paused && outstanding >= 0L) {
                if (!pausableReader.isCompleted()) {
                    try {
                        pausableReader.resume();
                    }
                    catch (XMLStreamException | SAXException xmlReadingException) {
                        sink.error((Throwable)new LogicalSourceResolverException("Error reading XML source.", (Throwable)xmlReadingException));
                    }
                }
            } else if (!paused && outstanding < 0L) {
                pausableReader.pause();
            }
        });
        sink.onDispose(() -> this.cleanup(inputStream));
        HashMap<Expression, LogicalSource> logicalSourceByExpression = new HashMap<Expression, LogicalSource>();
        logicalSources.forEach(logicalSource -> {
            this.setNamespaces((LogicalSource)logicalSource);
            try {
                logicalSourceByExpression.put(this.xmlDog.addXPath(logicalSource.getIterator()), (LogicalSource)logicalSource);
            }
            catch (SAXPathException saxPathException) {
                sink.error((Throwable)new LogicalSourceResolverException(String.format("Error parsing XPath expression: %s", logicalSource.getIterator()), (Throwable)saxPathException));
            }
        });
        Event event = this.xmlDog.createEvent();
        this.bridgeAndListen(logicalSourceByExpression, event, sink, outstandingRequests);
        try {
            this.xmlDog.sniff(event, new InputSource(inputStream), (XMLReader)((Object)pausableReader));
        }
        catch (XPathException xpathException) {
            sink.error((Throwable)new LogicalSourceResolverException("Error executing XPath expression.", (Throwable)xpathException));
        }
    }

    private void bridgeAndListen(final Map<Expression, LogicalSource> logicalSourceByExpression, Event event, final FluxSink<LogicalSourceRecord<XdmItem>> sink, final AtomicLong outstandingRequests) {
        final Map<Expression, Boolean> expressionCompletion = logicalSourceByExpression.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> false));
        event.setXMLBuilder((XMLBuilder)new DOMBuilder());
        event.setListener((EvaluationListener)new InstantEvaluationListener(){
            private final DocumentBuilder docBuilder;
            {
                this.docBuilder = XPathResolver.this.xpathProcessor.newDocumentBuilder();
            }

            public void onNodeHit(Expression expression, NodeItem nodeItem) {
                LogicalSource logicalSource = (LogicalSource)logicalSourceByExpression.get(expression);
                sink.next((Object)LogicalSourceRecord.of((LogicalSource)logicalSource, (Object)this.docBuilder.wrap(nodeItem.xml)));
                outstandingRequests.decrementAndGet();
            }

            public void finishedNodeSet(Expression expression) {
                expressionCompletion.put(expression, true);
                if (expressionCompletion.values().stream().allMatch(Boolean::valueOf)) {
                    sink.complete();
                }
            }

            public void onResult(Expression expression, Object o) {
                LogicalSource logicalSource = (LogicalSource)logicalSourceByExpression.get(expression);
                sink.next((Object)LogicalSourceRecord.of((LogicalSource)logicalSource, (Object)this.docBuilder.wrap(o)));
                outstandingRequests.decrementAndGet();
            }
        });
    }

    private void cleanup(InputStream inputStream) {
        try {
            inputStream.close();
        }
        catch (IOException ioException) {
            throw new LogicalSourceResolverException("Error closing input stream.", (Throwable)ioException);
        }
    }

    public LogicalSourceResolver.ExpressionEvaluationFactory<XdmItem> getExpressionEvaluationFactory() {
        return entry -> expression -> {
            this.logEvaluateExpression((String)expression, LOG);
            try {
                XPathSelector selector = this.xpathCompiler.compile(expression).load();
                selector.setContextItem(entry);
                XdmValue value = selector.evaluate();
                if (value.size() > 1) {
                    ArrayList results = new ArrayList();
                    value.forEach(item -> {
                        String stringValue = this.getItemStringValue((XdmItem)item, value);
                        if (stringValue != null) {
                            results.add(stringValue);
                        }
                    });
                    return Optional.of(results);
                }
                if (value.size() == 0) {
                    return Optional.empty();
                }
                XdmItem item2 = value.itemAt(0);
                return Optional.ofNullable(this.getItemStringValue(item2, value));
            }
            catch (SaxonApiException e) {
                throw new LogicalSourceResolverException(String.format("Error applying XPath expression [%s] to entry [%s]", expression, entry), (Throwable)e);
            }
        };
    }

    private String getItemStringValue(XdmItem item, XdmValue value) {
        if (item.getStringValue().length() == 0) {
            return null;
        }
        return this.autoNodeTextExtraction ? item.getStringValue() : value.toString();
    }

    @Generated
    private XPathResolver(DefaultNamespaceContext nsContext, XMLDog xmlDog, Processor xpathProcessor, XPathCompiler xpathCompiler, boolean autoNodeTextExtraction) {
        this.nsContext = nsContext;
        this.xmlDog = xmlDog;
        this.xpathProcessor = xpathProcessor;
        this.xpathCompiler = xpathCompiler;
        this.autoNodeTextExtraction = autoNodeTextExtraction;
    }
}

