/*
 * Decompiled with CFR 0.152.
 */
package io.carml.logicalsourceresolver;

import java.io.InputStream;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.xml.stream.Location;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import jlibs.xml.sax.AbstractXMLReader;
import jlibs.xml.stream.STAXAttributes;
import jlibs.xml.stream.STAXLocator;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class PausableStaxXmlReader
extends AbstractXMLReader {
    private final XMLInputFactory factory;
    private final AtomicBoolean readingPaused = new AtomicBoolean();
    private boolean readingCompleted = false;
    private XMLStreamReader reader = null;
    private Attributes attrs = null;

    public PausableStaxXmlReader(XMLInputFactory factory) {
        this.factory = factory;
        this.factory.setProperty("javax.xml.stream.isSupportingExternalEntities", false);
    }

    public PausableStaxXmlReader() {
        this(XMLInputFactory.newInstance());
    }

    public void parse(InputSource input) throws SAXException {
        try {
            this.reader = input.getByteStream() != null ? this.factory.createXMLStreamReader(input.getByteStream(), input.getEncoding()) : (input.getCharacterStream() != null ? this.factory.createXMLStreamReader(input.getCharacterStream()) : this.factory.createXMLStreamReader(input.getSystemId(), (InputStream)null));
            this.attrs = new STAXAttributes(this.reader);
            this.start();
        }
        catch (XMLStreamException ex) {
            throw new SAXException(ex);
        }
    }

    public void parse(String systemId) throws SAXException {
        this.parse(new InputSource(systemId));
    }

    public boolean isPaused() {
        return this.readingPaused.get();
    }

    public boolean isCompleted() {
        return this.readingCompleted;
    }

    public void pause() {
        this.readingPaused.compareAndSet(false, true);
    }

    private void start() throws SAXException, XMLStreamException {
        int eventType = this.reader.getEventType();
        if (eventType != 7 && eventType != 1) {
            throw new IllegalStateException("XMLStreamReader not at start of document or element");
        }
        this.run(eventType);
    }

    public void resume() throws SAXException, XMLStreamException {
        this.readingPaused.compareAndSet(true, false);
        int eventType = this.reader.next();
        this.run(eventType);
    }

    private void run(int eventType) throws SAXException, XMLStreamException {
        while (true) {
            switch (eventType) {
                case 1: {
                    this.handleStartElement();
                    break;
                }
                case 2: {
                    this.handleEndElement();
                    break;
                }
                case 3: {
                    this.handleProcessingInstruction();
                    break;
                }
                case 4: 
                case 6: 
                case 12: {
                    this.handleCharacters();
                    break;
                }
                case 5: {
                    this.handleComment();
                    break;
                }
                case 7: {
                    this.handleStartDocument();
                    break;
                }
                case 8: {
                    this.handleEndDocument();
                    return;
                }
                case 11: {
                    this.handleDtd();
                    break;
                }
            }
            try {
                if (this.readingPaused.get()) break;
                eventType = this.reader.next();
            }
            catch (XMLStreamException ex) {
                throw new SAXException(ex);
            }
        }
    }

    private void handleStartElement() throws SAXException {
        String prefix;
        int nsCount = this.reader.getNamespaceCount();
        for (int i = 0; i < nsCount; ++i) {
            prefix = this.reader.getNamespacePrefix(i);
            String uri = this.reader.getNamespaceURI(i);
            this.handler.startPrefixMapping(prefix == null ? "" : prefix, uri == null ? "" : uri);
        }
        String localName = this.reader.getLocalName();
        prefix = this.reader.getPrefix();
        String qname = prefix == null || prefix.length() == 0 ? localName : prefix + ":" + localName;
        String uri = this.reader.getNamespaceURI();
        this.handler.startElement(uri == null ? "" : uri, localName, qname, this.attrs);
    }

    private void handleEndElement() throws SAXException {
        String localName = this.reader.getLocalName();
        String prefix = this.reader.getPrefix();
        String qname = prefix == null || prefix.length() == 0 ? localName : prefix + ":" + localName;
        String uri = this.reader.getNamespaceURI();
        this.handler.endElement(uri == null ? "" : uri, localName, qname);
        int nsCount = this.reader.getNamespaceCount();
        for (int i = 0; i < nsCount; ++i) {
            prefix = this.reader.getNamespacePrefix(i);
            this.handler.endPrefixMapping(prefix == null ? "" : prefix);
        }
    }

    private void handleProcessingInstruction() throws SAXException {
        this.handler.processingInstruction(this.reader.getPITarget(), this.reader.getPIData());
    }

    private void handleCharacters() throws SAXException {
        this.handler.characters(this.reader.getTextCharacters(), this.reader.getTextStart(), this.reader.getTextLength());
    }

    private void handleComment() throws SAXException {
        this.handler.comment(this.reader.getTextCharacters(), this.reader.getTextStart(), this.reader.getTextLength());
    }

    private void handleStartDocument() throws SAXException {
        this.handler.setDocumentLocator((Locator)new STAXLocator(this.reader));
        this.handler.startDocument();
    }

    private void handleEndDocument() throws SAXException, XMLStreamException {
        this.handler.endDocument();
        this.reader.close();
        this.readingCompleted = true;
    }

    private void handleDtd() throws SAXException {
        Location location = this.reader.getLocation();
        this.handler.startDTD(null, location.getPublicId(), location.getSystemId());
        this.handler.endDTD();
    }
}

