/*
 * Decompiled with CFR 0.152.
 */
package io.carml.logicalsourceresolver;

import com.google.common.collect.Iterables;
import com.univocity.parsers.common.record.Record;
import com.univocity.parsers.csv.CsvParser;
import com.univocity.parsers.csv.CsvParserSettings;
import io.carml.logicalsourceresolver.LogicalSourceRecord;
import io.carml.logicalsourceresolver.LogicalSourceResolver;
import io.carml.logicalsourceresolver.LogicalSourceResolverException;
import io.carml.logicalsourceresolver.ResolvedSource;
import io.carml.model.LogicalSource;
import io.carml.util.LogUtil;
import java.io.InputStream;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;

public class CsvResolver
implements LogicalSourceResolver<Record> {
    @Generated
    private static final Logger LOG = LoggerFactory.getLogger(CsvResolver.class);

    public static CsvResolver getInstance() {
        return new CsvResolver();
    }

    public Function<ResolvedSource<?>, Flux<LogicalSourceRecord<Record>>> getLogicalSourceRecords(Set<LogicalSource> logicalSourceFilter) {
        return resolvedSource -> this.getCsvRecordFlux((ResolvedSource<?>)resolvedSource, logicalSourceFilter);
    }

    private Flux<LogicalSourceRecord<Record>> getCsvRecordFlux(ResolvedSource<?> resolvedSource, Set<LogicalSource> logicalSources) {
        if (logicalSources.size() > 1) {
            throw new LogicalSourceResolverException(String.format("Multiple logical sources found, but only one supported. Logical sources: %n%s", LogUtil.exception(logicalSources)));
        }
        if (logicalSources.isEmpty()) {
            throw new IllegalStateException("No logical sources registered");
        }
        LogicalSource logicalSource = (LogicalSource)Iterables.getOnlyElement(logicalSources);
        if (resolvedSource == null || resolvedSource.getResolved().isEmpty()) {
            throw new LogicalSourceResolverException(String.format("No source provided for logical sources:%n%s", LogUtil.exception(logicalSources)));
        }
        Object resolved = resolvedSource.getResolved().get();
        if (resolved instanceof InputStream) {
            return this.getCsvRecordFlux((InputStream)resolved).map(lsRecord -> LogicalSourceRecord.of((LogicalSource)logicalSource, (Object)lsRecord));
        }
        if (resolved instanceof Record) {
            return Flux.just((Object)LogicalSourceRecord.of((LogicalSource)logicalSource, (Object)((Record)resolved)));
        }
        throw new LogicalSourceResolverException(String.format("Unsupported source object provided for logical sources:%n%s", LogUtil.exception(logicalSources)));
    }

    private Flux<Record> getCsvRecordFlux(InputStream inputStream) {
        CsvParserSettings settings = new CsvParserSettings();
        settings.setHeaderExtractionEnabled(true);
        settings.setLineSeparatorDetectionEnabled(true);
        settings.setDelimiterDetectionEnabled(true);
        settings.setReadInputOnSeparateThread(true);
        settings.setMaxCharsPerColumn(-1);
        CsvParser parser = new CsvParser(settings);
        return Flux.fromIterable((Iterable)parser.iterateRecords(inputStream));
    }

    public LogicalSourceResolver.ExpressionEvaluationFactory<Record> getExpressionEvaluationFactory() {
        return row -> headerName -> {
            this.logEvaluateExpression((String)headerName, LOG);
            return Optional.ofNullable(row.getString(headerName));
        };
    }

    @Generated
    private CsvResolver() {
    }
}

