/*
 * Decompiled with CFR 0.152.
 */
package io.cana.steam.online.container;

import io.cana.steam.common.bean.Peer;
import io.cana.steam.online.constant.OnlineConstant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OnlineWheel {
    private static final Logger log = LoggerFactory.getLogger(OnlineWheel.class);
    private final int index;
    private final long[] peers;
    private final long now;
    private int used;

    public OnlineWheel(long nowPeer) {
        this(0, nowPeer);
    }

    public OnlineWheel(int nowIndex, long nowPeer) {
        this.now = nowPeer;
        this.index = nowIndex;
        this.peers = new long[OnlineConstant.Default.WHEEL_SIZE];
        this.peers[nowIndex] = nowPeer;
        this.used = 1;
    }

    public OnlineWheel(int nowIndex, long nowPeer, long[] snapPeers) {
        this.now = nowPeer;
        this.index = nowIndex;
        int size = snapPeers.length;
        long[] peers = new long[size];
        for (int i = 0; i < size; ++i) {
            long snapPeer = snapPeers[i];
            if (snapPeer <= 0L) continue;
            peers[i] = snapPeer;
            ++this.used;
        }
        this.peers = peers;
        this.peers[nowIndex] = nowPeer;
        ++this.used;
    }

    public long getPeer(int idx) {
        if (idx < 0) {
            return 0L;
        }
        return this.peers[idx];
    }

    public boolean addPeer(int idx, long peer) {
        if (idx >= this.peers.length) {
            return false;
        }
        this.peers[idx] = peer;
        ++this.used;
        return true;
    }

    public long delPeer(int idx) {
        long peer;
        if (idx >= 0 && (peer = this.peers[idx]) > 0L) {
            this.peers[idx] = 0L;
            --this.used;
            return peer;
        }
        return 0L;
    }

    public int delPeer(long peer) {
        int idx = this.indexOf(peer);
        if (idx >= 0) {
            this.peers[idx] = 0L;
            --this.used;
            return idx;
        }
        return -1;
    }

    public int delPeer(Peer peer) {
        return this.delPeer(peer.toNum());
    }

    public long nextPeer(long inPeer) {
        int idx = -1;
        long first = -1L;
        for (int i = 0; i < this.peers.length; ++i) {
            long peer = this.peers[i];
            if (peer <= 0L) continue;
            if (idx >= 0) {
                return peer;
            }
            if (first < 0L) {
                first = peer;
            }
            if (peer != inPeer) continue;
            idx = i;
        }
        return first;
    }

    public long nextPeer(Peer inPeer) {
        return this.nextPeer(inPeer.toNum());
    }

    public long nextPeer() {
        return this.nextPeer(this.now);
    }

    public int indexOf(long peer) {
        if (peer <= 0L) {
            return -1;
        }
        for (int i = 0; i < this.peers.length; ++i) {
            if (this.peers[i] != peer) continue;
            return i;
        }
        return -1;
    }

    public int indexOf(Peer peer) {
        return this.indexOf(peer.toNum());
    }

    public boolean isFull() {
        return this.used >= this.peers.length;
    }

    public int getSize() {
        return this.peers.length;
    }

    public int getIndex() {
        return this.index;
    }

    public long[] getPeers() {
        return this.peers;
    }

    public long getNow() {
        return this.now;
    }

    public int getUsed() {
        return this.used;
    }
}

