/*
 * Decompiled with CFR 0.152.
 */
package io.cana.steam.online.container;

import io.cana.steam.common.utils.CollectionUtil;
import io.cana.steam.online.Member;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OnlineDrawer {
    private static final Logger log = LoggerFactory.getLogger(OnlineDrawer.class);
    private final HashMap<Long, Member> members;
    private final HashMap<String, Set<Member>> groups;

    public OnlineDrawer() {
        this.members = CollectionUtil.newHashMap((int)64);
        this.groups = CollectionUtil.newHashMap((int)8);
    }

    private OnlineDrawer(HashMap<Long, Member> members, HashMap<String, Set<Member>> groups) {
        this.members = members;
        this.groups = groups;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void addMember(Member member) {
        if (null == member || null == this.members || null == this.groups) {
            return;
        }
        Long peer = member.getPeer();
        this.members.put(peer, member);
        String group = member.getGroup();
        Set groupList = this.groups.getOrDefault(group, new HashSet());
        if (groupList.contains(member)) return;
        Class<OnlineDrawer> clazz = OnlineDrawer.class;
        synchronized (OnlineDrawer.class) {
            if (groupList.contains(member)) return;
            groupList.add(member);
            this.groups.put(group, groupList);
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return;
        }
    }

    public void updateMember(Member member) {
        if (null == member || null == this.members || null == this.groups) {
            return;
        }
        Long peer = member.getPeer();
        this.members.put(peer, member);
    }

    public Member removeMember(Long peer) {
        if (null == this.members || null == this.groups) {
            return null;
        }
        Member member = this.members.remove(peer);
        if (null == member) {
            return null;
        }
        Set<Member> groupList = this.groups.get(member.getGroup());
        if (CollectionUtil.isEmpty(groupList)) {
            return member;
        }
        groupList.remove(member);
        return member;
    }

    public Member getMember(Long peer) {
        return this.members.get(peer);
    }

    public int allSize() {
        return this.members.size();
    }

    public HashMap<Long, Member> allMembers() {
        return this.members;
    }

    public int groupSize(String group) {
        Set<Member> set = this.groups.get(group);
        return null == set ? 0 : set.size();
    }

    public List<Member> groupMembers(String group) {
        Set<Member> set = this.groups.get(group);
        return null == set ? new ArrayList<Member>() : new ArrayList<Member>(set);
    }

    public static OnlineDrawer fromMembers(Collection<Member> list) {
        if (CollectionUtil.isEmpty(list)) {
            return new OnlineDrawer();
        }
        HashMap members = CollectionUtil.newHashMap((int)list.size());
        HashMap<String, Set<Member>> groups = new HashMap<String, Set<Member>>(16);
        for (Member member : list) {
            if (null == member) continue;
            Long peer = member.getPeer();
            String group = member.getGroup();
            members.put(peer, member);
            Set groupList = groups.getOrDefault(group, new HashSet());
            groupList.add(member);
            groups.put(group, groupList);
        }
        return new OnlineDrawer(members, groups);
    }
}

