/*
 * Decompiled with CFR 0.152.
 */
package io.cana.steam.online;

import io.cana.steam.common.bean.Peer;
import io.cana.steam.common.kind.ClassLoader;
import io.cana.steam.online.Member;
import io.cana.steam.online.container.OnlineDrawer;
import io.cana.steam.online.container.OnlineState;
import io.cana.steam.online.exception.ConstructFailedException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Online {
    private static final Logger log = LoggerFactory.getLogger(Online.class);
    protected OnlineDrawer drawer = new OnlineDrawer();

    public abstract boolean start(Member var1, Peer ... var2);

    public abstract boolean leave();

    public abstract OnlineState state();

    public OnlineDrawer getDrawer() {
        return this.drawer;
    }

    public Member getMember(Long peer) {
        return Objects.requireNonNull(this.drawer).getMember(peer);
    }

    public void updateMember(Member member) {
        Objects.requireNonNull(this.drawer).updateMember(member);
    }

    public void removeMember(Long peer) {
        Objects.requireNonNull(this.drawer).removeMember(peer);
    }

    public List<Member> allMembers() {
        return new ArrayList<Member>(Objects.requireNonNull(this.drawer).allMembers().values());
    }

    public List<Member> groupMembers(String group) {
        return new ArrayList<Member>(Objects.requireNonNull(this.drawer).groupMembers(group));
    }

    public static Online bootstrap(Member local, Peer ... seeds) {
        try {
            Online online = Online.implement(Online.class, new Object[0]);
            if (online.start(local, seeds)) {
                return online;
            }
            return null;
        }
        catch (Exception e) {
            log.error("[CELLA] Create online instance error", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private static <T> T implement(Class<T> clazz, Object ... params) {
        try {
            return (T)ClassLoader.constructImplementObject((String)("META-INF/online/" + clazz.getName()), (Object[])params);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new ConstructFailedException(e.getMessage(), e);
        }
    }
}

