/*
 * Decompiled with CFR 0.152.
 */
package io.cana.steam.online;

import io.cana.steam.common.bean.Peer;
import io.cana.steam.online.constant.OnlineConstant;
import java.util.HashMap;
import java.util.Map;

public class Member {
    private final long peer;
    private final String group;
    private final Map<String, String> metadata;

    public static Member fromPort(int port) {
        return new Member(new Peer(port).toNum(), OnlineConstant.Default.DEFAULT_GROUP, new HashMap<String, String>());
    }

    public static Member fromPort(int port, String group) {
        return new Member(new Peer(port).toNum(), group, new HashMap<String, String>());
    }

    public static Member fromPort(int port, Map<String, String> metadata) {
        return new Member(new Peer(port).toNum(), OnlineConstant.Default.DEFAULT_GROUP, metadata);
    }

    public static Member fromPort(int port, String group, Map<String, String> metadata) {
        return new Member(new Peer(port).toNum(), group, metadata);
    }

    public static Member fromPeer(long peer) {
        return new Member(peer, OnlineConstant.Default.DEFAULT_GROUP, new HashMap<String, String>());
    }

    public static Member fromPeer(long peer, String group) {
        return new Member(peer, group, new HashMap<String, String>());
    }

    public static Member fromPeer(long peer, Map<String, String> metadata) {
        return new Member(peer, OnlineConstant.Default.DEFAULT_GROUP, metadata);
    }

    public static Member fromPeer(long peer, String group, Map<String, String> metadata) {
        return new Member(peer, group, metadata);
    }

    private Member(long peer, String group, Map<String, String> metadata) {
        this.peer = peer < 0L ? new Peer(-1).toNum() : peer;
        this.group = group;
        this.metadata = metadata;
    }

    public Object put(String key, int value) {
        return this.metadata.put(key, String.valueOf(value));
    }

    public Object put(String key, long value) {
        return this.metadata.put(key, String.valueOf(value));
    }

    public Object put(String key, boolean value) {
        return this.metadata.put(key, String.valueOf(value));
    }

    public Object put(String key, String value) {
        return this.metadata.put(key, value);
    }

    public void put(Map<String, String> map) {
        this.metadata.putAll(map);
    }

    public int get(String key, int def) {
        String value = this.metadata.get(key);
        if (null == value) {
            return def;
        }
        return Integer.parseInt(value);
    }

    public long get(String key, long def) {
        String value = this.metadata.get(key);
        if (null == value) {
            return def;
        }
        return Long.parseLong(value);
    }

    public boolean get(String key, boolean def) {
        String value = this.metadata.get(key);
        if (null == value) {
            return def;
        }
        return Boolean.parseBoolean(value);
    }

    public String get(String key, String def) {
        return this.metadata.getOrDefault(key, def);
    }

    public Peer peer() {
        return Peer.fromNum((long)this.peer);
    }

    public long getPeer() {
        return this.peer;
    }

    public String getGroup() {
        return this.group;
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Member)) {
            return false;
        }
        Member other = (Member)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return this.getPeer() == other.getPeer();
    }

    protected boolean canEqual(Object other) {
        return other instanceof Member;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $peer = this.getPeer();
        result = result * 59 + (int)($peer >>> 32 ^ $peer);
        return result;
    }

    public String toString() {
        return "Member(peer=" + this.getPeer() + ", group=" + this.getGroup() + ", metadata=" + this.getMetadata() + ")";
    }
}

