/*
 * Decompiled with CFR 0.152.
 */
package io.camassia.spring.dbunit;

import io.camassia.spring.dbunit.api.DatabaseTester;
import io.camassia.spring.dbunit.api.connection.ConnectionSupplier;
import io.camassia.spring.dbunit.api.customization.TableDefaults;
import io.camassia.spring.dbunit.api.dataset.DataSetParser;
import io.camassia.spring.dbunit.api.dataset.xml.XmlDataSetParser;
import io.camassia.spring.dbunit.api.extensions.CellMappingExtension;
import io.camassia.spring.dbunit.api.extensions.DefaultTemplatedCellMappingExtension;
import io.camassia.spring.dbunit.api.extensions.Defaults;
import io.camassia.spring.dbunit.api.extensions.Extensions;
import io.camassia.spring.dbunit.api.extensions.NullCellMappingExtension;
import io.camassia.spring.dbunit.api.extensions.ResourceBasedValueCellMappingExtension;
import io.camassia.spring.dbunit.api.extensions.TemplatedCellMappingExtension;
import io.camassia.spring.dbunit.api.io.DefaultLocalResourceLoader;
import io.camassia.spring.dbunit.api.io.ResourceLoader;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.dbunit.database.DatabaseConfig;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.test.context.TestConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;

@TestConfiguration
@ComponentScan(basePackageClasses={DatabaseTester.class})
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0017J\b\u0010\u0005\u001a\u00020\u0006H\u0017JF\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u00102\n\b\u0001\u0010\u0011\u001a\u0004\u0018\u00010\u00122\b\b\u0001\u0010\u0013\u001a\u00020\u0014H\u0017J\b\u0010\u0015\u001a\u00020\rH\u0017J&\u0010\u000f\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\r2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\u0006\u0010\u000b\u001a\u00020\u0006H\u0017\u00a8\u0006\u0019"}, d2={"Lio/camassia/spring/dbunit/SpringBootTestDbUnitConfiguration;", "", "()V", "defaultDataSetParser", "Lio/camassia/spring/dbunit/api/dataset/DataSetParser;", "defaultDatabaseConfig", "Lorg/dbunit/database/DatabaseConfig;", "defaultDatabaseTester", "Lio/camassia/spring/dbunit/api/DatabaseTester;", "connectionSupplier", "Lio/camassia/spring/dbunit/api/connection/ConnectionSupplier;", "config", "resourceLoader", "Lio/camassia/spring/dbunit/api/io/ResourceLoader;", "dataSetParser", "extensions", "Lio/camassia/spring/dbunit/api/extensions/Extensions;", "schema", "", "failOnUnusedOverrides", "", "defaultResourceLoader", "defaults", "", "Lio/camassia/spring/dbunit/api/customization/TableDefaults;", "spring-boot-test-dbunit"})
public class SpringBootTestDbUnitConfiguration {
    @Bean
    @ConditionalOnMissingBean
    @NotNull
    public DatabaseConfig defaultDatabaseConfig() {
        return new DatabaseConfig();
    }

    @Bean
    @ConditionalOnMissingBean
    @NotNull
    public ResourceLoader defaultResourceLoader() {
        return new DefaultLocalResourceLoader();
    }

    @Bean
    @ConditionalOnMissingBean
    @NotNull
    public DataSetParser defaultDataSetParser() {
        return new XmlDataSetParser();
    }

    @Bean
    @ConditionalOnMissingBean
    @NotNull
    public Extensions extensions(@NotNull ResourceLoader resourceLoader, @NotNull List<TableDefaults> defaults, @NotNull DatabaseConfig config) {
        Intrinsics.checkNotNullParameter((Object)resourceLoader, (String)"resourceLoader");
        Intrinsics.checkNotNullParameter(defaults, (String)"defaults");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Object object = config.getProperty("http://www.dbunit.org/features/caseSensitiveTableNames");
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Boolean");
        }
        Defaults dbDefaults = new Defaults(defaults, (Boolean)object == false);
        Object[] objectArray = new CellMappingExtension[]{TemplatedCellMappingExtension.INSTANCE, NullCellMappingExtension.INSTANCE, new ResourceBasedValueCellMappingExtension(resourceLoader), new DefaultTemplatedCellMappingExtension(dbDefaults)};
        return new Extensions(CollectionsKt.listOf((Object[])objectArray), dbDefaults);
    }

    @Bean
    @ConditionalOnMissingBean
    @NotNull
    public DatabaseTester defaultDatabaseTester(@NotNull ConnectionSupplier connectionSupplier, @NotNull DatabaseConfig config, @NotNull ResourceLoader resourceLoader, @NotNull DataSetParser dataSetParser, @NotNull Extensions extensions, @Value(value="${spring.dbunit.schema:#{null}}") @Nullable String schema, @Value(value="${spring.dbunit.fail_on_unused_overrides:true}") boolean failOnUnusedOverrides) {
        Intrinsics.checkNotNullParameter((Object)connectionSupplier, (String)"connectionSupplier");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)resourceLoader, (String)"resourceLoader");
        Intrinsics.checkNotNullParameter((Object)dataSetParser, (String)"dataSetParser");
        Intrinsics.checkNotNullParameter((Object)extensions, (String)"extensions");
        return new DatabaseTester(connectionSupplier, config, resourceLoader, dataSetParser, extensions, schema, failOnUnusedOverrides);
    }
}

