/*
 * Decompiled with CFR 0.152.
 */
package io.camassia.spring.dbunit.api.connection;

import io.camassia.spring.dbunit.api.connection.ConnectionSupplier;
import java.sql.Connection;
import java.sql.DriverManager;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.dbunit.database.DatabaseConnection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0007J\b\u0010\b\u001a\u00020\tH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lio/camassia/spring/dbunit/api/connection/JdbcConnectionSupplier;", "Lio/camassia/spring/dbunit/api/connection/ConnectionSupplier;", "driverClass", "", "url", "username", "password", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getConnection", "Ljava/sql/Connection;", "spring-boot-test-dbunit"})
public final class JdbcConnectionSupplier
implements ConnectionSupplier {
    @NotNull
    private final String driverClass;
    @NotNull
    private final String url;
    @Nullable
    private final String username;
    @Nullable
    private final String password;

    public JdbcConnectionSupplier(@NotNull String driverClass, @NotNull String url, @Nullable String username, @Nullable String password) {
        Intrinsics.checkNotNullParameter((Object)driverClass, (String)"driverClass");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        this.driverClass = driverClass;
        this.url = url;
        this.username = username;
        this.password = password;
        Class.forName(this.driverClass);
    }

    public /* synthetic */ JdbcConnectionSupplier(String string, String string2, String string3, String string4, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            string3 = null;
        }
        if ((n & 8) != 0) {
            string4 = null;
        }
        this(string, string2, string3, string4);
    }

    @Override
    @NotNull
    public Connection getConnection() {
        Connection connection;
        if (this.username == null && this.password == null) {
            Connection connection2 = DriverManager.getConnection(this.url);
            connection = connection2;
            Intrinsics.checkNotNullExpressionValue((Object)connection2, (String)"getConnection(url)");
        } else {
            Connection connection3 = DriverManager.getConnection(this.url, this.username, this.password);
            connection = connection3;
            Intrinsics.checkNotNullExpressionValue((Object)connection3, (String)"getConnection(url, username, password)");
        }
        return connection;
    }

    @Override
    public void afterCreation(@NotNull DatabaseConnection connection) {
        ConnectionSupplier.DefaultImpls.afterCreation(this, connection);
    }
}

