/*
 * Decompiled with CFR 0.152.
 */
package io.bytom.api;

import com.google.gson.annotations.SerializedName;
import io.bytom.api.Address;
import io.bytom.api.Receiver;
import io.bytom.exception.BytomException;
import io.bytom.http.BytomResponse;
import io.bytom.http.Client;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class Account {
    public String id;
    public String alias;
    @SerializedName(value="key_index")
    public int keyIndex;
    public int quorum;
    public List<String> xpubs;

    public void delete(Client client, String account_info) throws BytomException {
        HashMap<String, String> req = new HashMap<String, String>();
        req.put("account_info", account_info);
        client.request("delete-account", req, (Type)((Object)Account.class));
    }

    public static class AddressBuilder {
        @SerializedName(value="account_alias")
        public String accountAlias;
        @SerializedName(value="account_id")
        public String accountId;

        public Items list(Client client) throws BytomException {
            Items items = new Items();
            items.setClient(client);
            items.setAddressBuilder(this);
            return items.query();
        }

        public Address validate(Client client, String address) throws BytomException {
            HashMap<String, String> req = new HashMap<String, String>();
            req.put("address", address);
            return (Address)client.request("validate-address", req, (Type)((Object)Address.class));
        }

        public AddressBuilder setAccountAlias(String alias) {
            this.accountAlias = alias;
            return this;
        }

        public AddressBuilder setAccountId(String id) {
            this.accountId = id;
            return this;
        }

        public static class Items
        extends BytomResponse<Address> {
            public AddressBuilder addressBuilder;

            public void setAddressBuilder(AddressBuilder builder) {
                this.addressBuilder = builder;
            }

            public Items query() throws BytomException {
                Items items = (Items)this.client.requestList("list-addresses", this.addressBuilder, (Type)((Object)Items.class));
                return items;
            }
        }
    }

    public static class ReceiverBuilder {
        @SerializedName(value="account_alias")
        public String accountAlias;
        @SerializedName(value="account_id")
        public String accountId;

        public Receiver create(Client client) throws BytomException {
            return (Receiver)client.request("create-account-receiver", this, (Type)((Object)Receiver.class));
        }

        public ReceiverBuilder setAccountAlias(String alias) {
            this.accountAlias = alias;
            return this;
        }

        public ReceiverBuilder setAccountId(String id) {
            this.accountId = id;
            return this;
        }
    }

    public static class QueryBuilder {
        public Items list(Client client) throws BytomException {
            Items items = new Items();
            items.setClient(client);
            return items.query();
        }
    }

    public static class Items
    extends BytomResponse<Account> {
        public Items query() throws BytomException {
            Items items = (Items)this.client.requestList("list-accounts", null, (Type)((Object)Items.class));
            return items;
        }
    }

    public static class Builder {
        @SerializedName(value="root_xpubs")
        public List<String> xpubs = new ArrayList<String>();
        public String alias;
        public int quorum;
        public String access_token;

        public Account create(Client client) throws BytomException {
            return (Account)client.request("create-account", this, (Type)((Object)Account.class));
        }

        public Builder setQuorum(int quorum) {
            this.quorum = quorum;
            return this;
        }

        public Builder setAlias(String alias) {
            this.alias = alias;
            return this;
        }

        public Builder setAccessToken(String access_token) {
            this.access_token = access_token;
            return this;
        }

        public Builder setXpubs(List<String> xpubs) {
            this.xpubs = new ArrayList<String>(xpubs);
            return this;
        }

        public Builder addXpub(String xpub) {
            this.xpubs.add(xpub);
            return this;
        }
    }
}

