/*
 * Decompiled with CFR 0.152.
 */
package io.bytom.api;

import io.bytom.exception.BytomException;
import io.bytom.http.BytomResponse;
import io.bytom.http.Client;
import java.lang.reflect.Type;
import java.util.HashMap;

public class TransactionFeed {
    public String alias;
    public String filter;
    public TransactionFeedParam param;

    public static TransactionFeed get(Client client, String alias) throws BytomException {
        HashMap<String, String> req = new HashMap<String, String>();
        req.put("alias", alias);
        return (TransactionFeed)client.requestGet("get-transaction-feed", req, "txfeed", (Type)((Object)TransactionFeed.class));
    }

    public static boolean update(Client client, String alias, String filter) throws BytomException {
        HashMap<String, String> req = new HashMap<String, String>();
        req.put("alias", alias);
        req.put("filter", filter);
        return client.request("update-transaction-feed", req);
    }

    public static Items list(Client client) throws BytomException {
        Items items = new Items();
        items.setClient(client);
        return items.query();
    }

    public static boolean delete(Client client, String alias) throws BytomException {
        HashMap<String, String> req = new HashMap<String, String>();
        req.put("alias", alias);
        return client.request("delete-transaction-feed", req);
    }

    public class TransactionFeedParam {
        public String assetid;
        public long lowerlimit;
        public long upperlimit;
    }

    public static class Items
    extends BytomResponse<TransactionFeed> {
        public Items query() throws BytomException {
            Items items = (Items)this.client.requestList("list-transaction-feeds", null, (Type)((Object)Items.class));
            return items;
        }
    }

    public static class Builder {
        public String alias;
        public String filter;

        public Builder setAlias(String alias) {
            this.alias = alias;
            return this;
        }

        public Builder setFilter(String filter) {
            this.filter = filter;
            return this;
        }

        public boolean create(Client client) throws BytomException {
            return client.request("create-transaction-feed", this);
        }
    }
}

