/*
 * Decompiled with CFR 0.152.
 */
package io.burt.jmespath.jacksonjr;

import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.TreeCodec;
import com.fasterxml.jackson.jr.ob.JSON;
import com.fasterxml.jackson.jr.stree.JacksonJrsTreeCodec;
import com.fasterxml.jackson.jr.stree.JrsArray;
import com.fasterxml.jackson.jr.stree.JrsBoolean;
import com.fasterxml.jackson.jr.stree.JrsNull;
import com.fasterxml.jackson.jr.stree.JrsNumber;
import com.fasterxml.jackson.jr.stree.JrsObject;
import com.fasterxml.jackson.jr.stree.JrsString;
import com.fasterxml.jackson.jr.stree.JrsValue;
import io.burt.jmespath.BaseRuntime;
import io.burt.jmespath.JmesPathType;
import io.burt.jmespath.RuntimeConfiguration;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class JacksonJrRuntime
extends BaseRuntime<JrsValue> {
    private final JSON json;

    public JacksonJrRuntime() {
        this(RuntimeConfiguration.defaultConfiguration());
    }

    public JacksonJrRuntime(RuntimeConfiguration configuration) {
        this(configuration, JSON.builder().treeCodec((TreeCodec)new JacksonJrsTreeCodec()).build());
    }

    public JacksonJrRuntime(RuntimeConfiguration configuration, JSON json) {
        super(configuration);
        this.json = json;
    }

    public JrsValue parseString(String str) {
        try {
            return (JrsValue)this.json.treeFrom((Object)str);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public List<JrsValue> toList(JrsValue value) {
        if (value == null) {
            return Collections.emptyList();
        }
        if (value.isArray()) {
            return new JrsArrayListWrapper((JrsArray)value);
        }
        if (value.isObject()) {
            JrsObject object = (JrsObject)value;
            ArrayList<JrsValue> list = new ArrayList<JrsValue>(object.size());
            Iterator iterator = object.fields();
            while (iterator.hasNext()) {
                Map.Entry entry = (Map.Entry)iterator.next();
                list.add((JrsValue)entry.getValue());
            }
            return list;
        }
        return Collections.emptyList();
    }

    public String toString(JrsValue value) {
        if (JsonToken.VALUE_STRING.equals((Object)value.asToken())) {
            return value.asText();
        }
        try {
            return this.json.asString((Object)value);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public Number toNumber(JrsValue value) {
        if (value.isValueNode() && value.isNumber()) {
            JrsNumber number = (JrsNumber)value;
            return number.getValue();
        }
        return null;
    }

    public boolean isTruthy(JrsValue value) {
        if (value.isContainerNode()) {
            return value.size() > 0;
        }
        if (value.isValueNode()) {
            switch (value.asToken()) {
                case VALUE_STRING: {
                    return !value.asText().isEmpty();
                }
                case VALUE_FALSE: 
                case VALUE_NULL: {
                    return false;
                }
            }
            return true;
        }
        return !value.isMissingNode();
    }

    public JmesPathType typeOf(JrsValue value) {
        switch (value.asToken()) {
            case START_ARRAY: {
                return JmesPathType.ARRAY;
            }
            case VALUE_EMBEDDED_OBJECT: 
            case START_OBJECT: {
                return JmesPathType.OBJECT;
            }
            case VALUE_STRING: {
                return JmesPathType.STRING;
            }
            case VALUE_NUMBER_INT: 
            case VALUE_NUMBER_FLOAT: {
                return JmesPathType.NUMBER;
            }
            case VALUE_FALSE: 
            case VALUE_TRUE: {
                return JmesPathType.BOOLEAN;
            }
            case VALUE_NULL: {
                return JmesPathType.NULL;
            }
        }
        throw new IllegalStateException(String.format("Unknown node type encountered: %s", value.asToken()));
    }

    public JrsValue getProperty(JrsValue value, JrsValue name) {
        if (JsonToken.VALUE_NULL.equals((Object)value.asToken())) {
            return JrsNull.instance();
        }
        JrsValue node = value.get(name.asText());
        return node != null ? node : this.createNull();
    }

    public Collection<JrsValue> getPropertyNames(JrsValue value) {
        if (value.isObject()) {
            ArrayList<JrsValue> names = new ArrayList<JrsValue>(value.size());
            Iterator fieldNames = value.fieldNames();
            while (fieldNames.hasNext()) {
                names.add(this.createString((String)fieldNames.next()));
            }
            return names;
        }
        return Collections.emptyList();
    }

    public JrsValue createNull() {
        return JrsNull.instance();
    }

    public JrsValue createArray(Collection<JrsValue> elements) {
        ArrayList<Object> values = new ArrayList<Object>();
        for (JrsValue node : elements) {
            if (node == null) {
                values.add(JrsNull.instance());
                continue;
            }
            values.add(node);
        }
        return new JrsArray(values);
    }

    public JrsValue createString(String str) {
        return new JrsString(str);
    }

    public JrsValue createBoolean(boolean b) {
        return b ? JrsBoolean.TRUE : JrsBoolean.FALSE;
    }

    public JrsValue createObject(Map<JrsValue, JrsValue> obj) {
        HashMap<String, JrsValue> values = new HashMap<String, JrsValue>();
        for (Map.Entry<JrsValue, JrsValue> entry : obj.entrySet()) {
            values.put(entry.getKey().asText(), entry.getValue());
        }
        return new JrsObject(values);
    }

    public JrsValue createNumber(double n) {
        return new JrsNumber((Number)n);
    }

    public JrsValue createNumber(long n) {
        return new JrsNumber((Number)n);
    }

    private static class JrsArrayListWrapper
    extends AbstractList<JrsValue> {
        private final JrsArray array;

        JrsArrayListWrapper(JrsArray array) {
            this.array = array;
        }

        @Override
        public JrsValue get(int index) {
            return this.array.get(index);
        }

        @Override
        public int size() {
            return this.array.size();
        }
    }
}

