package io.burkard.cdk.services.wafv2.cfnWebACL

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object RateBasedStatementProperty {

  def apply(
    limit: Number,
    aggregateKeyType: String,
    forwardedIpConfig: Option[software.amazon.awscdk.services.wafv2.CfnWebACL.ForwardedIPConfigurationProperty] = None,
    scopeDownStatement: Option[software.amazon.awscdk.services.wafv2.CfnWebACL.StatementProperty] = None
  ): software.amazon.awscdk.services.wafv2.CfnWebACL.RateBasedStatementProperty =
    (new software.amazon.awscdk.services.wafv2.CfnWebACL.RateBasedStatementProperty.Builder)
      .limit(limit)
      .aggregateKeyType(aggregateKeyType)
      .forwardedIpConfig(forwardedIpConfig.orNull)
      .scopeDownStatement(scopeDownStatement.orNull)
      .build()
}
