package io.burkard.cdk.services.ssm

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnAssociation {

  def apply(
    internalResourceId: String,
    name: String,
    instanceId: Option[String] = None,
    waitForSuccessTimeoutSeconds: Option[Number] = None,
    associationName: Option[String] = None,
    documentVersion: Option[String] = None,
    targets: Option[List[_]] = None,
    syncCompliance: Option[String] = None,
    maxConcurrency: Option[String] = None,
    applyOnlyAtCronInterval: Option[Boolean] = None,
    complianceSeverity: Option[String] = None,
    automationTargetParameterName: Option[String] = None,
    maxErrors: Option[String] = None,
    calendarNames: Option[List[String]] = None,
    outputLocation: Option[software.amazon.awscdk.services.ssm.CfnAssociation.InstanceAssociationOutputLocationProperty] = None,
    scheduleExpression: Option[String] = None,
    parameters: Option[Map[String, _]] = None
  )(implicit stackCtx: software.amazon.awscdk.Stack): software.amazon.awscdk.services.ssm.CfnAssociation =
    software.amazon.awscdk.services.ssm.CfnAssociation.Builder
      .create(stackCtx, internalResourceId)
      .name(name)
      .instanceId(instanceId.orNull)
      .waitForSuccessTimeoutSeconds(waitForSuccessTimeoutSeconds.orNull)
      .associationName(associationName.orNull)
      .documentVersion(documentVersion.orNull)
      .targets(targets.map(_.asJava).orNull)
      .syncCompliance(syncCompliance.orNull)
      .maxConcurrency(maxConcurrency.orNull)
      .applyOnlyAtCronInterval(applyOnlyAtCronInterval.map(Boolean.box).getOrElse(java.lang.Boolean.FALSE))
      .complianceSeverity(complianceSeverity.orNull)
      .automationTargetParameterName(automationTargetParameterName.orNull)
      .maxErrors(maxErrors.orNull)
      .calendarNames(calendarNames.map(_.asJava).orNull)
      .outputLocation(outputLocation.orNull)
      .scheduleExpression(scheduleExpression.orNull)
      .parameters(parameters.map(_.asJava).orNull)
      .build()
}
