package io.burkard.cdk.services.sns.subscriptions

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object EmailSubscriptionProps {

  def apply(
    deadLetterQueue: Option[software.amazon.awscdk.services.sqs.IQueue] = None,
    filterPolicy: Option[Map[String, _ <: software.amazon.awscdk.services.sns.SubscriptionFilter]] = None,
    json: Option[Boolean] = None
  ): software.amazon.awscdk.services.sns.subscriptions.EmailSubscriptionProps =
    (new software.amazon.awscdk.services.sns.subscriptions.EmailSubscriptionProps.Builder)
      .deadLetterQueue(deadLetterQueue.orNull)
      .filterPolicy(filterPolicy.map(_.asJava).orNull)
      .json(json.map(Boolean.box).getOrElse(java.lang.Boolean.FALSE))
      .build()
}
