package io.burkard.cdk.services.s3.cfnBucket

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object WebsiteConfigurationProperty {

  def apply(
    errorDocument: Option[String] = None,
    indexDocument: Option[String] = None,
    redirectAllRequestsTo: Option[software.amazon.awscdk.services.s3.CfnBucket.RedirectAllRequestsToProperty] = None,
    routingRules: Option[List[_]] = None
  ): software.amazon.awscdk.services.s3.CfnBucket.WebsiteConfigurationProperty =
    (new software.amazon.awscdk.services.s3.CfnBucket.WebsiteConfigurationProperty.Builder)
      .errorDocument(errorDocument.orNull)
      .indexDocument(indexDocument.orNull)
      .redirectAllRequestsTo(redirectAllRequestsTo.orNull)
      .routingRules(routingRules.map(_.asJava).orNull)
      .build()
}
