package io.burkard.cdk.services.opsworkscm

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnServer {

  def apply(
    internalResourceId: String,
    serviceRoleArn: String,
    instanceType: String,
    instanceProfileArn: String,
    subnetIds: Option[List[String]] = None,
    keyPair: Option[String] = None,
    disableAutomatedBackup: Option[Boolean] = None,
    serverName: Option[String] = None,
    tags: Option[List[_ <: software.amazon.awscdk.CfnTag]] = None,
    customPrivateKey: Option[String] = None,
    securityGroupIds: Option[List[String]] = None,
    backupId: Option[String] = None,
    customDomain: Option[String] = None,
    preferredMaintenanceWindow: Option[String] = None,
    engineModel: Option[String] = None,
    associatePublicIpAddress: Option[Boolean] = None,
    customCertificate: Option[String] = None,
    backupRetentionCount: Option[Number] = None,
    engineAttributes: Option[List[_]] = None,
    preferredBackupWindow: Option[String] = None,
    engineVersion: Option[String] = None,
    engine: Option[String] = None
  )(implicit stackCtx: software.amazon.awscdk.Stack): software.amazon.awscdk.services.opsworkscm.CfnServer =
    software.amazon.awscdk.services.opsworkscm.CfnServer.Builder
      .create(stackCtx, internalResourceId)
      .serviceRoleArn(serviceRoleArn)
      .instanceType(instanceType)
      .instanceProfileArn(instanceProfileArn)
      .subnetIds(subnetIds.map(_.asJava).orNull)
      .keyPair(keyPair.orNull)
      .disableAutomatedBackup(disableAutomatedBackup.map(Boolean.box).getOrElse(java.lang.Boolean.FALSE))
      .serverName(serverName.orNull)
      .tags(tags.map(_.asJava).orNull)
      .customPrivateKey(customPrivateKey.orNull)
      .securityGroupIds(securityGroupIds.map(_.asJava).orNull)
      .backupId(backupId.orNull)
      .customDomain(customDomain.orNull)
      .preferredMaintenanceWindow(preferredMaintenanceWindow.orNull)
      .engineModel(engineModel.orNull)
      .associatePublicIpAddress(associatePublicIpAddress.map(Boolean.box).getOrElse(java.lang.Boolean.FALSE))
      .customCertificate(customCertificate.orNull)
      .backupRetentionCount(backupRetentionCount.orNull)
      .engineAttributes(engineAttributes.map(_.asJava).orNull)
      .preferredBackupWindow(preferredBackupWindow.orNull)
      .engineVersion(engineVersion.orNull)
      .engine(engine.orNull)
      .build()
}
