package io.burkard.cdk.services.lambda

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnLayerVersionPermission {

  def apply(
    internalResourceId: String,
    action: String,
    principal: String,
    layerVersionArn: String,
    organizationId: Option[String] = None
  )(implicit stackCtx: software.amazon.awscdk.Stack): software.amazon.awscdk.services.lambda.CfnLayerVersionPermission =
    software.amazon.awscdk.services.lambda.CfnLayerVersionPermission.Builder
      .create(stackCtx, internalResourceId)
      .action(action)
      .principal(principal)
      .layerVersionArn(layerVersionArn)
      .organizationId(organizationId.orNull)
      .build()
}
