package io.burkard.cdk.services.events

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object BaseArchiveProps {

  def apply(
    eventPattern: software.amazon.awscdk.services.events.EventPattern,
    retention: Option[software.amazon.awscdk.Duration] = None,
    description: Option[String] = None,
    archiveName: Option[String] = None
  ): software.amazon.awscdk.services.events.BaseArchiveProps =
    (new software.amazon.awscdk.services.events.BaseArchiveProps.Builder)
      .eventPattern(eventPattern)
      .retention(retention.orNull)
      .description(description.orNull)
      .archiveName(archiveName.orNull)
      .build()
}
