package io.burkard.cdk.services.efs

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object AccessPointProps {

  def apply(
    fileSystem: software.amazon.awscdk.services.efs.IFileSystem,
    path: Option[String] = None,
    createAcl: Option[software.amazon.awscdk.services.efs.Acl] = None,
    posixUser: Option[software.amazon.awscdk.services.efs.PosixUser] = None
  ): software.amazon.awscdk.services.efs.AccessPointProps =
    (new software.amazon.awscdk.services.efs.AccessPointProps.Builder)
      .fileSystem(fileSystem)
      .path(path.orNull)
      .createAcl(createAcl.orNull)
      .posixUser(posixUser.orNull)
      .build()
}
