package io.burkard.cdk.services.codebuild

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object ReportGroupProps {

  def apply(
    removalPolicy: Option[software.amazon.awscdk.RemovalPolicy] = None,
    exportBucket: Option[software.amazon.awscdk.services.s3.IBucket] = None,
    reportGroupName: Option[String] = None,
    zipExport: Option[Boolean] = None
  ): software.amazon.awscdk.services.codebuild.ReportGroupProps =
    (new software.amazon.awscdk.services.codebuild.ReportGroupProps.Builder)
      .removalPolicy(removalPolicy.orNull)
      .exportBucket(exportBucket.orNull)
      .reportGroupName(reportGroupName.orNull)
      .zipExport(zipExport.map(Boolean.box).getOrElse(java.lang.Boolean.FALSE))
      .build()
}
