package io.burkard.cdk.services.cloudfront.cfnResponseHeadersPolicy

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object ResponseHeadersPolicyConfigProperty {

  def apply(
    name: String,
    corsConfig: Option[software.amazon.awscdk.services.cloudfront.CfnResponseHeadersPolicy.CorsConfigProperty] = None,
    customHeadersConfig: Option[software.amazon.awscdk.services.cloudfront.CfnResponseHeadersPolicy.CustomHeadersConfigProperty] = None,
    securityHeadersConfig: Option[software.amazon.awscdk.services.cloudfront.CfnResponseHeadersPolicy.SecurityHeadersConfigProperty] = None,
    comment: Option[String] = None
  ): software.amazon.awscdk.services.cloudfront.CfnResponseHeadersPolicy.ResponseHeadersPolicyConfigProperty =
    (new software.amazon.awscdk.services.cloudfront.CfnResponseHeadersPolicy.ResponseHeadersPolicyConfigProperty.Builder)
      .name(name)
      .corsConfig(corsConfig.orNull)
      .customHeadersConfig(customHeadersConfig.orNull)
      .securityHeadersConfig(securityHeadersConfig.orNull)
      .comment(comment.orNull)
      .build()
}
