package io.burkard.cdk.services.backup

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object BackupPlanRuleProps {

  def apply(
    ruleName: Option[String] = None,
    backupVault: Option[software.amazon.awscdk.services.backup.IBackupVault] = None,
    startWindow: Option[software.amazon.awscdk.Duration] = None,
    moveToColdStorageAfter: Option[software.amazon.awscdk.Duration] = None,
    completionWindow: Option[software.amazon.awscdk.Duration] = None,
    deleteAfter: Option[software.amazon.awscdk.Duration] = None,
    scheduleExpression: Option[software.amazon.awscdk.services.events.Schedule] = None,
    enableContinuousBackup: Option[Boolean] = None
  ): software.amazon.awscdk.services.backup.BackupPlanRuleProps =
    (new software.amazon.awscdk.services.backup.BackupPlanRuleProps.Builder)
      .ruleName(ruleName.orNull)
      .backupVault(backupVault.orNull)
      .startWindow(startWindow.orNull)
      .moveToColdStorageAfter(moveToColdStorageAfter.orNull)
      .completionWindow(completionWindow.orNull)
      .deleteAfter(deleteAfter.orNull)
      .scheduleExpression(scheduleExpression.orNull)
      .enableContinuousBackup(enableContinuousBackup.map(Boolean.box).getOrElse(java.lang.Boolean.FALSE))
      .build()
}
