package io.burkard.cdk.services.sqs

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object Queue {

  def apply(
    internalResourceId: String,
    fifoThroughputLimit: Option[software.amazon.awscdk.services.sqs.FifoThroughputLimit] = None,
    retentionPeriod: Option[software.amazon.awscdk.Duration] = None,
    deadLetterQueue: Option[software.amazon.awscdk.services.sqs.DeadLetterQueue] = None,
    visibilityTimeout: Option[software.amazon.awscdk.Duration] = None,
    maxMessageSizeBytes: Option[Number] = None,
    deliveryDelay: Option[software.amazon.awscdk.Duration] = None,
    deduplicationScope: Option[software.amazon.awscdk.services.sqs.DeduplicationScope] = None,
    encryptionMasterKey: Option[software.amazon.awscdk.services.kms.IKey] = None,
    encryption: Option[software.amazon.awscdk.services.sqs.QueueEncryption] = None,
    queueName: Option[String] = None,
    receiveMessageWaitTime: Option[software.amazon.awscdk.Duration] = None,
    contentBasedDeduplication: Option[Boolean] = None,
    fifo: Option[Boolean] = None,
    removalPolicy: Option[software.amazon.awscdk.RemovalPolicy] = None,
    dataKeyReuse: Option[software.amazon.awscdk.Duration] = None
  )(implicit stackCtx: software.amazon.awscdk.Stack): software.amazon.awscdk.services.sqs.Queue =
    software.amazon.awscdk.services.sqs.Queue.Builder
      .create(stackCtx, internalResourceId)
      .fifoThroughputLimit(fifoThroughputLimit.orNull)
      .retentionPeriod(retentionPeriod.orNull)
      .deadLetterQueue(deadLetterQueue.orNull)
      .visibilityTimeout(visibilityTimeout.orNull)
      .maxMessageSizeBytes(maxMessageSizeBytes.orNull)
      .deliveryDelay(deliveryDelay.orNull)
      .deduplicationScope(deduplicationScope.orNull)
      .encryptionMasterKey(encryptionMasterKey.orNull)
      .encryption(encryption.orNull)
      .queueName(queueName.orNull)
      .receiveMessageWaitTime(receiveMessageWaitTime.orNull)
      .contentBasedDeduplication(contentBasedDeduplication.map(Boolean.box).getOrElse(java.lang.Boolean.FALSE))
      .fifo(fifo.map(Boolean.box).getOrElse(java.lang.Boolean.FALSE))
      .removalPolicy(removalPolicy.orNull)
      .dataKeyReuse(dataKeyReuse.orNull)
      .build()
}
