package io.burkard.cdk.services.sam.cfnFunction

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object AuthProperty {

  def apply(
    resourcePolicy: Option[software.amazon.awscdk.services.sam.CfnFunction.AuthResourcePolicyProperty] = None,
    apiKeyRequired: Option[Boolean] = None,
    authorizationScopes: Option[List[String]] = None,
    authorizer: Option[String] = None
  ): software.amazon.awscdk.services.sam.CfnFunction.AuthProperty =
    (new software.amazon.awscdk.services.sam.CfnFunction.AuthProperty.Builder)
      .resourcePolicy(resourcePolicy.orNull)
      .apiKeyRequired(apiKeyRequired.map(Boolean.box).getOrElse(java.lang.Boolean.FALSE))
      .authorizationScopes(authorizationScopes.map(_.asJava).orNull)
      .authorizer(authorizer.orNull)
      .build()
}
