package io.burkard.cdk.services.macie

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnFindingsFilterProps {

  def apply(
    name: String,
    findingCriteria: software.amazon.awscdk.services.macie.CfnFindingsFilter.FindingCriteriaProperty,
    description: Option[String] = None,
    position: Option[Number] = None,
    action: Option[String] = None
  ): software.amazon.awscdk.services.macie.CfnFindingsFilterProps =
    (new software.amazon.awscdk.services.macie.CfnFindingsFilterProps.Builder)
      .name(name)
      .findingCriteria(findingCriteria)
      .description(description.orNull)
      .position(position.orNull)
      .action(action.orNull)
      .build()
}
