package io.burkard.cdk.services.location

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnMap {

  def apply(
    internalResourceId: String,
    configuration: software.amazon.awscdk.services.location.CfnMap.MapConfigurationProperty,
    mapName: String,
    pricingPlan: String,
    description: Option[String] = None
  )(implicit stackCtx: software.amazon.awscdk.Stack): software.amazon.awscdk.services.location.CfnMap =
    software.amazon.awscdk.services.location.CfnMap.Builder
      .create(stackCtx, internalResourceId)
      .configuration(configuration)
      .mapName(mapName)
      .pricingPlan(pricingPlan)
      .description(description.orNull)
      .build()
}
