package io.burkard.cdk.services.emr.cfnCluster

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object SpotProvisioningSpecificationProperty {

  def apply(
    timeoutDurationMinutes: Number,
    timeoutAction: String,
    allocationStrategy: Option[String] = None,
    blockDurationMinutes: Option[Number] = None
  ): software.amazon.awscdk.services.emr.CfnCluster.SpotProvisioningSpecificationProperty =
    (new software.amazon.awscdk.services.emr.CfnCluster.SpotProvisioningSpecificationProperty.Builder)
      .timeoutDurationMinutes(timeoutDurationMinutes)
      .timeoutAction(timeoutAction)
      .allocationStrategy(allocationStrategy.orNull)
      .blockDurationMinutes(blockDurationMinutes.orNull)
      .build()
}
