package io.burkard.cdk.services.ec2

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object PrivateSubnetAttributes {

  def apply(
    subnetId: Option[String] = None,
    routeTableId: Option[String] = None,
    availabilityZone: Option[String] = None,
    ipv4CidrBlock: Option[String] = None
  ): software.amazon.awscdk.services.ec2.PrivateSubnetAttributes =
    (new software.amazon.awscdk.services.ec2.PrivateSubnetAttributes.Builder)
      .subnetId(subnetId.orNull)
      .routeTableId(routeTableId.orNull)
      .availabilityZone(availabilityZone.orNull)
      .ipv4CidrBlock(ipv4CidrBlock.orNull)
      .build()
}
